/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.planner.operators.Filter;
import io.crate.planner.operators.ForeignCollect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;

public class MergeFilterAndForeignCollect
implements Rule<Filter> {
    private final Capture<ForeignCollect> collectCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(ForeignCollect.class).capturedAs(this.collectCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context ruleContext) {
        ForeignCollect collect = captures.get(this.collectCapture);
        if (collect.fdw().supportsQueryPushdown(filter.query())) {
            return new ForeignCollect(collect.fdw(), collect.relation(), collect.outputs(), collect.where().add(filter.query()), collect.executeAs());
        }
        return null;
    }
}

