/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.RelationNames;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.rule.MoveFilterBeneathJoin;
import io.crate.sql.tree.JoinType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;

public class MoveConstantJoinConditionsBeneathJoin
implements Rule<JoinPlan> {
    private final Pattern<JoinPlan> pattern;
    private final EnumSet<JoinType> SUPPORTED_JOIN_TYPE = EnumSet.of(JoinType.INNER, JoinType.LEFT, JoinType.RIGHT, JoinType.CROSS);

    public MoveConstantJoinConditionsBeneathJoin() {
        this.pattern = Pattern.typeOf(JoinPlan.class).with(join -> this.SUPPORTED_JOIN_TYPE.contains(join.joinType()) && !join.moveConstantJoinConditionRuleApplied() && MoveConstantJoinConditionsBeneathJoin.hasConstantJoinConditions(join.joinCondition()));
    }

    private static boolean hasConstantJoinConditions(Symbol joinCondition) {
        if (joinCondition == null) {
            return false;
        }
        for (Symbol condition : QuerySplitter.split(joinCondition).values()) {
            if (MoveConstantJoinConditionsBeneathJoin.numberOfRelationsUsed(condition) > 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Pattern<JoinPlan> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(JoinPlan joinPlan, Captures captures, Rule.Context context) {
        UnaryOperator<LogicalPlan> resolvePlan = context.resolvePlan();
        Symbol conditions = joinPlan.joinCondition();
        Map<Set<RelationName>, Symbol> allConditions = QuerySplitter.split(conditions);
        HashMap<Set<RelationName>, Symbol> constantConditions = new HashMap<Set<RelationName>, Symbol>(allConditions.size());
        HashSet<Symbol> nonConstantConditions = new HashSet<Symbol>(allConditions.size());
        for (Map.Entry<Set<RelationName>, Symbol> condition : allConditions.entrySet()) {
            if (MoveConstantJoinConditionsBeneathJoin.numberOfRelationsUsed(condition.getValue()) <= 1) {
                constantConditions.put(condition.getKey(), condition.getValue());
                continue;
            }
            nonConstantConditions.add(condition.getValue());
        }
        if (!constantConditions.isEmpty() && !nonConstantConditions.isEmpty()) {
            LogicalPlan newRhs;
            LogicalPlan newLhs;
            HashSet<RelationName> lhsRelations = new HashSet<RelationName>(joinPlan.lhs().relationNames());
            HashSet<RelationName> rhsRelations = new HashSet<RelationName>(joinPlan.rhs().relationNames());
            if (joinPlan.joinType() == JoinType.INNER || joinPlan.joinType() == JoinType.CROSS) {
                lhs = (LogicalPlan)resolvePlan.apply(joinPlan.lhs());
                LogicalPlan rhs = (LogicalPlan)resolvePlan.apply(joinPlan.rhs());
                Symbol queryForLhs = (Symbol)constantConditions.remove(lhsRelations);
                Symbol queryForRhs = (Symbol)constantConditions.remove(rhsRelations);
                newLhs = MoveFilterBeneathJoin.getNewSource(queryForLhs, lhs);
                newRhs = MoveFilterBeneathJoin.getNewSource(queryForRhs, rhs);
            } else if (joinPlan.joinType() == JoinType.RIGHT) {
                lhs = (LogicalPlan)resolvePlan.apply(joinPlan.lhs());
                Symbol queryForLhs = (Symbol)constantConditions.remove(lhsRelations);
                newLhs = MoveFilterBeneathJoin.getNewSource(queryForLhs, lhs);
                newRhs = joinPlan.rhs();
            } else if (joinPlan.joinType() == JoinType.LEFT) {
                LogicalPlan rhs = (LogicalPlan)resolvePlan.apply(joinPlan.rhs());
                Symbol queryForRhs = (Symbol)constantConditions.remove(rhsRelations);
                newRhs = MoveFilterBeneathJoin.getNewSource(queryForRhs, rhs);
                newLhs = joinPlan.lhs();
            } else {
                return joinPlan.withMoveConstantJoinConditionRuleApplied(true);
            }
            LinkedHashSet newJoinConditions = new LinkedHashSet(nonConstantConditions);
            newJoinConditions.addAll(constantConditions.values());
            return new JoinPlan(newLhs, newRhs, joinPlan.joinType(), AndOperator.join(newJoinConditions), joinPlan.isFiltered(), joinPlan.isRewriteFilterOnOuterJoinToInnerJoinDone(), joinPlan.isLookUpJoinRuleApplied(), true, joinPlan.lookUpJoin());
        }
        return joinPlan.withMoveConstantJoinConditionRuleApplied(true);
    }

    private static int numberOfRelationsUsed(Symbol joinCondition) {
        return RelationNames.getShallow(joinCondition).size();
    }
}

