/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.planner.operators.Eval;
import io.crate.planner.operators.HashJoin;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.sql.tree.JoinType;
import io.crate.statistics.Stats;

public class ReorderHashJoin
implements Rule<HashJoin> {
    private final Pattern<HashJoin> pattern = Pattern.typeOf(HashJoin.class).with(j -> j.joinType() == JoinType.INNER);

    @Override
    public Pattern<HashJoin> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(HashJoin plan, Captures captures, Rule.Context context) {
        boolean expectedRowsAvailable;
        PlanStats planStats = context.planStats();
        Stats lhStats = planStats.get(plan.lhs());
        Stats rhStats = planStats.get(plan.rhs());
        boolean bl = expectedRowsAvailable = lhStats.numDocs() != -1L && rhStats.numDocs() != -1L;
        if (expectedRowsAvailable && lhStats.numDocs() < rhStats.numDocs()) {
            return Eval.create(new HashJoin(plan.rhs(), plan.lhs(), plan.joinCondition(), plan.joinType(), plan.lookUpJoin().invert()), plan.outputs());
        }
        return null;
    }
}

