/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol.rule;

import io.crate.expression.operator.Operators;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.symbol.FunctionLookup;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.util.List;

public class SwapCastsInComparisonOperators
implements Rule<Function> {
    private final Capture<Function> castCapture = new Capture();
    private final Pattern<Function> pattern = Pattern.typeOf(Function.class).with(f -> Operators.COMPARISON_OPERATORS.contains(f.name())).with(f -> f.arguments().get(1).symbolType().isValueOrParameterSymbol()).with(f -> f.arguments().get(0), Pattern.typeOf(Function.class).capturedAs(this.castCapture).with(f -> f.name().equals("_cast")).with(f -> f.arguments().get(0).symbolType() == SymbolType.REFERENCE)).with(SwapCastsInComparisonOperators::isSwappable);

    private static boolean isSwappable(Function cmpOp) {
        Symbol symbol = cmpOp.arguments().get(1);
        if (symbol instanceof Literal) {
            Literal literal = (Literal)symbol;
            Function cast = (Function)cmpOp.arguments().getFirst();
            Reference ref = (Reference)cast.arguments().getFirst();
            DataType<?> refInnerType = ArrayType.unnest(ref.valueType());
            DataType literalInnerType = ArrayType.unnest(literal.valueType());
            if (!DataTypes.isNumeric(literalInnerType) || !DataTypes.isNumeric(refInnerType)) {
                return literalInnerType.isConvertableTo(refInnerType, false);
            }
            if (DataTypes.isSafeConversion(literalInnerType, refInnerType)) {
                return true;
            }
            return SwapCastsInComparisonOperators.isNarrowingConversionPossible(literal.value(), ref.valueType());
        }
        return true;
    }

    private static boolean isNarrowingConversionPossible(Object value, DataType<?> targetType) {
        if (DataTypes.isArray(targetType)) {
            return ((List)value).stream().allMatch(e -> SwapCastsInComparisonOperators.isNarrowingConversionPossible(e, ((ArrayType)targetType).innerType()));
        }
        try {
            Number n = (Number)value;
            String literalStr = String.valueOf(n);
            String castedStr = String.valueOf(targetType.implicitCast(n));
            return new BigDecimal(literalStr).compareTo(new BigDecimal(castedStr)) == 0;
        }
        catch (ClassCastException | IllegalArgumentException e2) {
            return false;
        }
    }

    @Override
    public Pattern<Function> pattern() {
        return this.pattern;
    }

    @Override
    public Symbol apply(Function operator, Captures captures, NodeContext nodeCtx, FunctionLookup functionLookup, Symbol parentNode) {
        Symbol literalOrParam = operator.arguments().get(1);
        Function castFunction = captures.get(this.castCapture);
        Symbol reference = castFunction.arguments().get(0);
        DataType<?> targetType = reference.valueType();
        CastMode castMode = castFunction.castMode();
        assert (castMode != null) : "Pattern matched, function must be a cast";
        Symbol castedLiteral = literalOrParam.cast(targetType, castMode);
        return new Function(operator.signature(), List.of(reference, castedLiteral), operator.valueType());
    }
}

