/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.selectivity;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.operator.Operators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.MostCommonValues;
import io.crate.statistics.Stats;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SelectivityFunctions {
    private static final double DEFAULT_EQ_SEL = 0.005;
    private static final double MAGIC_SEL = 0.333;

    public static long estimateNumRows(NodeContext nodeCtx, TransactionContext txnCtx, Stats stats, Symbol query, @Nullable Row params) {
        SelectivityEstimator estimator = new SelectivityEstimator(nodeCtx, txnCtx, stats, params);
        Double selectivity = query.accept(estimator, null);
        return (long)((double)stats.numDocs() * selectivity);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static double genericOpSelectivity(NodeContext nodeCtx, TransactionContext txnCtx, Stats stats, Function function, Row params) {
        if (!SelectivityFunctions.$assertionsDisabled && !Operators.COMPARISON_OPERATORS.contains(function.name())) {
            throw new AssertionError((Object)"genericOpSelectivity only works for Operators like >, <, <= and >=");
        }
        defaultSel = 0.333;
        arguments = function.arguments();
        if (!SelectivityFunctions.$assertionsDisabled && arguments.size() != 2) {
            throw new AssertionError((Object)"Operator must have two arguments");
        }
        lhs = arguments.get(0);
        lhsColumn = SelectivityFunctions.getColumn(lhs);
        if (lhsColumn == null) {
            return defaultSel;
        }
        rhs = arguments.get(1);
        if (!(rhs instanceof ParameterSymbol)) ** GOTO lbl-1000
        param = (ParameterSymbol)rhs;
        if (params != null) {
            rhsValue /* !! */  = params.get(param.index());
        } else if (rhs instanceof Literal) {
            literal = (Literal)rhs;
            rhsValue /* !! */  = literal.value();
        } else {
            return defaultSel;
        }
        if (rhsValue /* !! */  == null) {
            return 0.0;
        }
        lhsStats = stats.getColumnStats(lhsColumn);
        if (lhsStats == null || lhsStats.mostCommonValues().isEmpty()) {
            return defaultSel;
        }
        operator = (Scalar)nodeCtx.functions().getQualified(function);
        mostCommonValues = lhsStats.mostCommonValues();
        selectivity = 0.0;
        for (i = 0; i < mostCommonValues.length(); ++i) {
            value = mostCommonValues.value(i);
            result = (Boolean)operator.evaluate(txnCtx, nodeCtx, new Input[]{(Input)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$genericOpSelectivity$0(java.lang.Object ), ()Ljava/lang/Object;)(value), (Input)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$genericOpSelectivity$1(java.lang.Object ), ()Ljava/lang/Object;)(rhsValue /* !! */ )});
            if (result == null || !result.booleanValue()) continue;
            selectivity += mostCommonValues.frequency(i);
        }
        return selectivity;
    }

    private static double isNullSelectivity(Symbol arg, Stats stats) {
        ColumnIdent column = SelectivityFunctions.getColumn(arg);
        if (column == null) {
            return 0.333;
        }
        ColumnStats<?> columnStats = stats.statsByColumn().get(column);
        if (columnStats == null) {
            return 0.333;
        }
        return columnStats.nullFraction();
    }

    private static double eqSelectivity(Symbol leftArg, Symbol rightArg, Stats stats, @Nullable Row params) {
        ColumnIdent lhsColumn = SelectivityFunctions.getColumn(leftArg);
        if (lhsColumn == null) {
            return 0.005;
        }
        ColumnStats<?> lhsStats = stats.statsByColumn().get(lhsColumn);
        if (lhsStats == null) {
            return 0.005;
        }
        if (rightArg instanceof ParameterSymbol) {
            ParameterSymbol param = (ParameterSymbol)rightArg;
            if (params != null) {
                Object value = params.get(param.index());
                return SelectivityFunctions.eqSelectivityFromValueAndStats(value, lhsStats);
            }
        }
        if (rightArg instanceof Literal) {
            Literal literal = (Literal)rightArg;
            return SelectivityFunctions.eqSelectivityFromValueAndStats(literal.value(), lhsStats);
        }
        if (rightArg instanceof Reference || rightArg instanceof ScopedSymbol) {
            ColumnIdent rhsColumn = SelectivityFunctions.getColumn(rightArg);
            if (rhsColumn == null) {
                return 1.0 / lhsStats.approxDistinct();
            }
            ColumnStats<?> rhsStats = stats.statsByColumn().get(rhsColumn);
            if (rhsStats == null) {
                return 1.0 / lhsStats.approxDistinct();
            }
            MostCommonValues<?> lhsMcv = lhsStats.mostCommonValues();
            MostCommonValues<?> rhsMcv = rhsStats.mostCommonValues();
            if (!lhsMcv.isEmpty() && !rhsMcv.isEmpty()) {
                return SelectivityFunctions.selectivityFromMvcMatches(lhsStats, rhsStats);
            }
            double nullfrac1 = lhsStats.nullFraction();
            double nullfrac2 = rhsStats.nullFraction();
            double selectivity = (1.0 - nullfrac1) * (1.0 - nullfrac2);
            if (lhsStats.approxDistinct() > rhsStats.approxDistinct()) {
                return selectivity / lhsStats.approxDistinct();
            }
            return selectivity / rhsStats.approxDistinct();
        }
        return 1.0 / lhsStats.approxDistinct();
    }

    private static double clamp(double value) {
        return Math.clamp(value, 0.0, 1.0);
    }

    private static double selectivityFromMvcMatches(ColumnStats<?> lhsStats, ColumnStats<?> rhsStats) {
        MostCommonValues<?> lhsMcv = lhsStats.mostCommonValues();
        MostCommonValues<?> rhsMcv = rhsStats.mostCommonValues();
        boolean[] hasmatch1 = new boolean[lhsMcv.length()];
        boolean[] hasmatch2 = new boolean[rhsMcv.length()];
        double matchfreq = 0.0;
        int numMatches = 0;
        block0: for (int i = 0; i < lhsMcv.length(); ++i) {
            Object lhsValue = lhsMcv.value(i);
            for (int j = 0; j < rhsMcv.length(); ++j) {
                if (hasmatch2[j]) continue;
                Object rhsValue = rhsMcv.value(j);
                if (lhsValue == null || !Objects.equals(lhsValue, rhsValue)) continue;
                hasmatch1[i] = true;
                hasmatch2[j] = true;
                matchfreq += lhsMcv.frequency(i) * rhsMcv.frequency(j);
                ++numMatches;
                continue block0;
            }
        }
        matchfreq = SelectivityFunctions.clamp(matchfreq);
        double matchfreq1 = 0.0;
        double unmatchfreq1 = 0.0;
        for (int i = 0; i < lhsMcv.length(); ++i) {
            if (hasmatch1[i]) {
                matchfreq1 += lhsMcv.frequency(i);
                continue;
            }
            unmatchfreq1 += lhsMcv.frequency(i);
        }
        matchfreq1 = SelectivityFunctions.clamp(matchfreq1);
        unmatchfreq1 = SelectivityFunctions.clamp(unmatchfreq1);
        double matchfreq2 = 0.0;
        double unmatchfreq2 = 0.0;
        for (int i = 0; i < rhsMcv.length(); ++i) {
            if (hasmatch2[i]) {
                matchfreq2 = rhsMcv.frequency(i);
                continue;
            }
            unmatchfreq1 = rhsMcv.frequency(i);
        }
        matchfreq2 = SelectivityFunctions.clamp(matchfreq2);
        unmatchfreq2 = SelectivityFunctions.clamp(unmatchfreq2);
        double otherfreq1 = SelectivityFunctions.clamp(1.0 - lhsStats.nullFraction() - matchfreq1 - unmatchfreq1);
        double otherfreq2 = SelectivityFunctions.clamp(1.0 - rhsStats.nullFraction() - matchfreq2 - unmatchfreq2);
        double totalsel1 = matchfreq;
        double nd1 = lhsStats.approxDistinct();
        double nd2 = rhsStats.approxDistinct();
        if (nd2 > (double)rhsMcv.length()) {
            totalsel1 += unmatchfreq1 * otherfreq2 / (nd2 - (double)rhsMcv.length());
        }
        if (nd2 > (double)numMatches) {
            totalsel1 += otherfreq1 * (otherfreq2 + unmatchfreq2) / (nd2 - (double)numMatches);
        }
        double totalsel2 = matchfreq;
        if (nd1 > (double)lhsMcv.length()) {
            totalsel2 += unmatchfreq2 * otherfreq1 / (nd1 - (double)lhsMcv.length());
        }
        if (nd1 > (double)numMatches) {
            totalsel2 += otherfreq2 * (otherfreq1 + unmatchfreq1) / (nd1 - (double)numMatches);
        }
        return Math.min(totalsel1, totalsel2);
    }

    private static double eqSelectivityFromValueAndStats(Object value, ColumnStats<?> columnStats) {
        if (value == null) {
            return 0.0;
        }
        MostCommonValues<?> mcv = columnStats.mostCommonValues();
        int idx = mcv.values().indexOf(value);
        if (idx < 0) {
            return 1.0 / columnStats.approxDistinct();
        }
        return mcv.frequencies()[idx];
    }

    @Nullable
    private static ColumnIdent getColumn(Symbol symbol) {
        Symbol symbol2 = symbol;
        Objects.requireNonNull(symbol2);
        Symbol symbol3 = symbol2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Reference.class, ScopedSymbol.class}, (Symbol)symbol3, n)) {
            case 0 -> {
                Reference ref = (Reference)symbol3;
                yield ref.column();
            }
            case 1 -> {
                ScopedSymbol scopedSymbol = (ScopedSymbol)symbol3;
                yield scopedSymbol.column();
            }
            default -> null;
        };
    }

    private static /* synthetic */ Object lambda$genericOpSelectivity$1(Object rhsValue) {
        return rhsValue;
    }

    private static /* synthetic */ Object lambda$genericOpSelectivity$0(Object value) {
        return value;
    }

    static class SelectivityEstimator
    extends SymbolVisitor<Void, Double> {
        private final Stats stats;
        @Nullable
        private final Row params;
        private final NodeContext nodeCtx;
        private final TransactionContext txnCtx;

        SelectivityEstimator(NodeContext nodeCtx, TransactionContext txnCtx, Stats stats, @Nullable Row params) {
            this.nodeCtx = nodeCtx;
            this.txnCtx = txnCtx;
            this.stats = stats;
            this.params = params;
        }

        @Override
        protected Double visitSymbol(Symbol symbol, Void context) {
            return 1.0;
        }

        @Override
        public Double visitLiteral(Literal<?> literal, Void context) {
            Object value = literal.value();
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return bool == false ? 0.0 : 1.0;
            }
            if (value == null) {
                return 0.0;
            }
            return (Double)super.visitLiteral(literal, context);
        }

        @Override
        public Double visitFunction(Function function, Void context) {
            switch (function.name()) {
                case "op_and": {
                    double selectivity = 1.0;
                    for (Symbol argument : function.arguments()) {
                        selectivity *= argument.accept(this, context).doubleValue();
                    }
                    return selectivity;
                }
                case "op_or": {
                    double sel1 = 1.0;
                    for (Symbol argument : function.arguments()) {
                        double sel2 = argument.accept(this, context);
                        sel1 = sel1 + sel2 - sel1 * sel2;
                    }
                    return sel1;
                }
                case "op_=": {
                    List<Symbol> arguments = function.arguments();
                    return SelectivityFunctions.eqSelectivity(arguments.get(0), arguments.get(1), this.stats, this.params);
                }
                case "op_not": {
                    return 1.0 - function.arguments().get(0).accept(this, context);
                }
                case "op_isnull": {
                    List<Symbol> arguments = function.arguments();
                    return SelectivityFunctions.isNullSelectivity(arguments.get(0), this.stats);
                }
            }
            if (Operators.COMPARISON_OPERATORS.contains(function.name())) {
                return SelectivityFunctions.genericOpSelectivity(this.nodeCtx, this.txnCtx, this.stats, function, this.params);
            }
            return 0.333;
        }
    }
}

