/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.AccessControl;
import io.crate.data.Row;
import io.crate.protocols.postgres.DelayableWriteChannel;
import io.crate.protocols.postgres.FormatCodes;
import io.crate.protocols.postgres.Messages;
import io.crate.protocols.postgres.types.PGType;
import io.crate.session.BaseResultReceiver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResultSetReceiver
extends BaseResultReceiver {
    private final String query;
    private final DelayableWriteChannel channel;
    private final List<PGType<?>> columnTypes;
    private final AccessControl accessControl;
    private final Channel directChannel;
    private final DelayableWriteChannel.DelayedWrites delayedWrites;
    @Nullable
    private final FormatCodes.FormatCode[] formatCodes;
    private long rowCount = 0L;

    ResultSetReceiver(String query, DelayableWriteChannel channel, DelayableWriteChannel.DelayedWrites delayedWrites, AccessControl accessControl, List<PGType<?>> columnTypes, @Nullable FormatCodes.FormatCode[] formatCodes) {
        this.query = query;
        this.channel = channel;
        this.delayedWrites = delayedWrites;
        this.directChannel = channel.bypassDelay();
        this.accessControl = accessControl;
        this.columnTypes = columnTypes;
        this.formatCodes = formatCodes;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) {
        CompletableFuture<Void> future;
        ++this.rowCount;
        ChannelFuture sendDataRow = Messages.sendDataRow(this.directChannel, row, this.columnTypes, this.formatCodes);
        boolean isWritable = this.directChannel.isWritable();
        if (isWritable) {
            future = null;
        } else {
            future = new CompletableFuture<Void>();
            sendDataRow.addListener(f -> {
                if (!f.isDone()) {
                    return;
                }
                if (f.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(f.cause());
                }
            });
        }
        if (!isWritable || this.rowCount % 1000L == 0L) {
            this.directChannel.flush();
        }
        return future;
    }

    @Override
    public void batchFinished() {
        ChannelFuture sendPortalSuspended = Messages.sendPortalSuspended(this.directChannel);
        this.channel.writePendingMessages(this.delayedWrites);
        this.channel.flush();
        sendPortalSuspended.addListener(f -> super.allFinished());
    }

    @Override
    public void allFinished() {
        ChannelFuture sendCommandComplete = Messages.sendCommandComplete(this.directChannel, this.query, this.rowCount);
        this.channel.writePendingMessages(this.delayedWrites);
        this.channel.flush();
        sendCommandComplete.addListener(f -> super.allFinished());
    }

    @Override
    public void fail(@NotNull Throwable throwable) {
        ChannelFuture sendErrorResponse = Messages.sendErrorResponse(this.directChannel, this.accessControl, throwable);
        this.channel.writePendingMessages(this.delayedWrites);
        this.channel.flush();
        sendErrorResponse.addListener(f -> super.fail(throwable));
    }
}

