/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class RegprocType
extends PGType<Regproc> {
    static final int OID = 24;
    private static final int TYPE_LEN = 4;
    private static final int TYPE_MOD = -1;
    public static final RegprocType INSTANCE = new RegprocType();

    private RegprocType() {
        super(24, 4, -1, "regproc");
    }

    @Override
    public int typArray() {
        return PGArray.REGPROC_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Regproc value) {
        buffer.writeInt(4);
        buffer.writeInt(value.oid());
        return 8;
    }

    @Override
    public Regproc readBinaryValue(ByteBuf buffer, int valueLength) {
        int oid = buffer.readInt();
        return Regproc.of(oid, String.valueOf(oid));
    }

    @Override
    public int writeAsText(ByteBuf buffer, @NotNull Regproc value) {
        byte[] bytes = value.name().getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
        return 4 + bytes.length;
    }

    @Override
    public Regproc readTextValue(ByteBuf buffer, int valueLength) {
        byte[] utf8 = new byte[valueLength];
        buffer.readBytes(utf8);
        return Regproc.of(new String(utf8, StandardCharsets.UTF_8));
    }

    @Override
    protected byte[] encodeAsUTF8Text(@NotNull Regproc value) {
        return value.name().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Regproc decodeUTF8Text(byte[] bytes) {
        return Regproc.of(new String(bytes, StandardCharsets.UTF_8));
    }
}

