/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import io.crate.replication.logical.metadata.RelationMetadata;
import io.crate.role.Role;
import io.crate.role.Roles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PublicationsStateAction
extends ActionType<Response> {
    public static final String NAME = "internal:crate:replication/logical/publication/state";
    public static final PublicationsStateAction INSTANCE = new PublicationsStateAction();
    private static final Logger LOGGER = LogManager.getLogger(PublicationsStateAction.class);

    public PublicationsStateAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends TransportResponse {
        private final Map<RelationName, RelationMetadata> relationsInPublications;
        private final List<String> unknownPublications;

        public Response(Map<RelationName, RelationMetadata> relationsInPublications, List<String> unknownPublications) {
            this.relationsInPublications = relationsInPublications;
            this.unknownPublications = unknownPublications;
        }

        public Response(StreamInput in) throws IOException {
            this.relationsInPublications = in.readMap(RelationName::new, RelationMetadata::new);
            this.unknownPublications = in.readList(StreamInput::readString);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.relationsInPublications, (o, v) -> v.writeTo(out), (o, v) -> v.writeTo(out));
            out.writeStringCollection(this.unknownPublications);
        }

        public Map<RelationName, RelationMetadata> relationsInPublications() {
            return this.relationsInPublications;
        }

        public List<String> unknownPublications() {
            return this.unknownPublications;
        }

        public String toString() {
            return "Response{relationsInPublications:" + String.valueOf(this.relationsInPublications) + ".unknownPublications:" + String.valueOf(this.unknownPublications) + "}";
        }

        public List<IndexMetadata> concreteIndices() {
            return this.relationsInPublications.values().stream().flatMap(x -> x.indices().stream()).toList();
        }

        public List<String> concreteTemplates() {
            return this.relationsInPublications.values().stream().map(x -> x.template()).filter(Objects::nonNull).map(x -> x.name()).toList();
        }

        public Collection<RelationName> tables() {
            return this.relationsInPublications.keySet();
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final List<String> publications;
        private final String subscribingUserName;

        public Request(List<String> publications, String subscribingUserName) {
            this.publications = publications;
            this.subscribingUserName = subscribingUserName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.publications = in.readList(StreamInput::readString);
            this.subscribingUserName = in.readString();
        }

        public List<String> publications() {
            return this.publications;
        }

        public String subscribingUserName() {
            return this.subscribingUserName;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.publications);
            out.writeString(this.subscribingUserName);
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        private final Roles roles;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Roles roles) {
            super(Settings.EMPTY, PublicationsStateAction.NAME, false, transportService, clusterService, threadPool, Request::new);
            this.roles = roles;
            TransportActionProxy.registerProxyAction(transportService, PublicationsStateAction.NAME, Response::new);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected Response read(StreamInput in) throws IOException {
            return new Response(in);
        }

        @Override
        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            Role subscriber = this.roles.findUser(request.subscribingUserName());
            if (subscriber == null) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Cannot build publication state, subscribing user '%s' was not found.", request.subscribingUserName()));
            }
            PublicationsMetadata publicationsMetadata = (PublicationsMetadata)state.metadata().custom("publications");
            if (publicationsMetadata == null) {
                LOGGER.trace("No publications found on remote cluster.");
                throw new IllegalStateException("Cannot build publication state, no publications found");
            }
            HashMap<RelationName, RelationMetadata> allRelationsInPublications = new HashMap<RelationName, RelationMetadata>();
            ArrayList<String> unknownPublications = new ArrayList<String>();
            for (String publicationName : request.publications()) {
                Publication publication = publicationsMetadata.publications().get(publicationName);
                if (publication == null) {
                    unknownPublications.add(publicationName);
                    continue;
                }
                Role publicationOwner = this.roles.findUser(publication.owner());
                allRelationsInPublications.putAll(publication.resolveCurrentRelations(state, this.roles, publicationOwner, subscriber, publicationName));
            }
            listener.onResponse(new Response(allRelationsInPublications, unknownPublications));
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }
}

