/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.common.exceptions.Exceptions;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.action.CreateSubscriptionRequest;
import io.crate.replication.logical.action.PublicationsStateAction;
import io.crate.replication.logical.exceptions.PublicationUnknownException;
import io.crate.replication.logical.exceptions.SubscriptionAlreadyExistsException;
import io.crate.replication.logical.metadata.RelationMetadata;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import io.crate.role.Roles;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateSubscriptionAction
extends TransportMasterNodeAction<CreateSubscriptionRequest, AcknowledgedResponse> {
    public static final String ACTION_NAME = "internal:crate:replication/logical/subscription/create";
    private final String source;
    private final LogicalReplicationService logicalReplicationService;
    private final Roles roles;

    @Inject
    public TransportCreateSubscriptionAction(TransportService transportService, ClusterService clusterService, LogicalReplicationService logicalReplicationService, ThreadPool threadPool, Roles roles) {
        super(ACTION_NAME, transportService, clusterService, threadPool, CreateSubscriptionRequest::new);
        this.logicalReplicationService = logicalReplicationService;
        this.roles = roles;
        this.source = "create-subscription";
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CreateSubscriptionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (this.roles.findUser(request.owner()) == null) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Subscription '%s' cannot be created as the user '%s' owning the subscription has been dropped.", request.name(), request.owner()));
        }
        ((CompletableFuture)this.logicalReplicationService.getPublicationState(request.name(), request.publications(), request.connectionInfo()).thenCompose(response -> {
            if (!response.unknownPublications().isEmpty()) {
                throw new PublicationUnknownException(response.unknownPublications().get(0));
            }
            for (RelationMetadata relationMetadata : response.relationsInPublications().values()) {
                if (relationMetadata.template() != null) {
                    TransportCreateSubscriptionAction.checkVersionCompatibility(relationMetadata.name().fqn(), state.nodes().getMinNodeVersion(), relationMetadata.template().settings());
                }
                if (relationMetadata.indices().isEmpty()) continue;
                IndexMetadata indexMetadata = relationMetadata.indices().get(0);
                TransportCreateSubscriptionAction.checkVersionCompatibility(relationMetadata.name().fqn(), state.nodes().getMinNodeVersion(), indexMetadata.getSettings());
            }
            this.logicalReplicationService.verifyTablesDoNotExist(request.name(), (PublicationsStateAction.Response)response);
            return this.submitClusterStateTask(request, (PublicationsStateAction.Response)response);
        })).whenComplete((acknowledgedResponse, err) -> {
            if (err == null) {
                listener.onResponse((AcknowledgedResponse)acknowledgedResponse);
            } else {
                listener.onFailure(Exceptions.toException((Throwable)err));
            }
        });
    }

    private static void checkVersionCompatibility(String tableFqn, Version subscriberMinNodeVersion, Settings settings) {
        Version publishedTableVersion = settings.getAsVersion("index.version.created", null);
        assert (publishedTableVersion != null) : "All published tables must have version created setting";
        if (subscriberMinNodeVersion.beforeMajorMinor(publishedTableVersion)) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "One of the published tables has version higher than subscriber's minimal node version. Table=%s, Table-Version=%s, Local-Minimal-Version: %s", tableFqn, publishedTableVersion, subscriberMinNodeVersion));
        }
    }

    private CompletableFuture<AcknowledgedResponse> submitClusterStateTask(final CreateSubscriptionRequest request, final PublicationsStateAction.Response publicationsStateResponse) {
        AckedClusterStateUpdateTask<AcknowledgedResponse> task = new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, (AckedRequest)request){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                SubscriptionsMetadata oldMetadata = (SubscriptionsMetadata)mdBuilder.getCustom("subscriptions");
                if (oldMetadata != null && oldMetadata.subscription().containsKey(request.name())) {
                    throw new SubscriptionAlreadyExistsException(request.name());
                }
                HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>();
                for (RelationName relation : publicationsStateResponse.tables()) {
                    relations.put(relation, new Subscription.RelationState(Subscription.State.INITIALIZING, null));
                }
                Subscription subscription = new Subscription(request.owner(), request.connectionInfo(), request.publications(), request.settings(), relations);
                SubscriptionsMetadata newMetadata = SubscriptionsMetadata.newInstance(oldMetadata);
                newMetadata.subscription().put(request.name(), subscription);
                assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
                mdBuilder.putCustom("subscriptions", newMetadata);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        };
        this.clusterService.submitStateUpdateTask(this.source, task);
        return task.completionFuture();
    }

    @Override
    protected ClusterBlockException checkBlock(CreateSubscriptionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

