/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MissingShardOperationsException
extends ElasticsearchException
implements ResourceUnknownException,
TableScopeException {
    private final RelationName relationName;

    public MissingShardOperationsException(RelationName relationName, String msg) {
        super(msg, new Object[0]);
        this.relationName = relationName;
    }

    public MissingShardOperationsException(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
    }

    public Collection<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
    }
}

