/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.plan;

import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.replication.logical.action.CreateSubscriptionRequest;
import io.crate.replication.logical.analyze.AnalyzedCreateSubscription;
import io.crate.replication.logical.exceptions.CreateSubscriptionException;
import io.crate.replication.logical.metadata.ConnectionInfo;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataTypes;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.settings.Settings;

public class CreateSubscriptionPlan
implements Plan {
    private final AnalyzedCreateSubscription analyzedCreateSubscription;

    public CreateSubscriptionPlan(AnalyzedCreateSubscription analyzedCreateSubscription) {
        this.analyzedCreateSubscription = analyzedCreateSubscription;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        String url = CreateSubscriptionPlan.validateAndConvertToString(eval.apply(this.analyzedCreateSubscription.connectionInfo()));
        ConnectionInfo connectionInfo = ConnectionInfo.fromURL(url);
        Settings settings = Settings.builder().put((GenericProperties<Object>)this.analyzedCreateSubscription.properties().map(eval)).build();
        String subscribingUser = connectionInfo.settings().get(ConnectionInfo.USERNAME.getKey());
        if (subscribingUser == null || subscribingUser.isEmpty()) {
            throw new CreateSubscriptionException(String.format(Locale.ENGLISH, "Setting '%s' must be provided on CREATE SUBSCRIPTION", ConnectionInfo.USERNAME.getKey()));
        }
        if (!settings.names().isEmpty()) {
            throw new CreateSubscriptionException("Settings with 'WITH' clause are not supported for CREATE SUBSCRIPTION");
        }
        CreateSubscriptionRequest request = new CreateSubscriptionRequest(plannerContext.transactionContext().sessionSettings().sessionUser().name(), this.analyzedCreateSubscription.name(), connectionInfo, this.analyzedCreateSubscription.publications(), settings);
        dependencies.createSubscriptionAction().execute(request).whenComplete(new OneRowActionListener<AcknowledgedResponse>(consumer, rCount -> new Row1((Object)(rCount == null ? -1L : 1L))));
    }

    private static String validateAndConvertToString(Object uri) {
        if (uri instanceof String) {
            String str = (String)uri;
            return str;
        }
        throw new CreateSubscriptionException("fileUri must be of type STRING. Got " + String.valueOf(DataTypes.guessType(uri)));
    }
}

