/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.repository;

import io.crate.replication.logical.action.GetFileChunkAction;
import io.crate.replication.logical.repository.RemoteClusterRepositoryFileChunk;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.MultiChunkTransfer;
import org.elasticsearch.indices.recovery.MultiFileWriter;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.threadpool.ThreadPool;

public class RemoteClusterMultiChunkTransfer
extends MultiChunkTransfer<StoreFileMetadata, RemoteClusterRepositoryFileChunk> {
    private static final String RESTORE_SHARD_TEMP_FILE_PREFIX = "CLUSTER_REPO_TEMP_";
    private static final Logger LOGGER = LogManager.getLogger(RemoteClusterMultiChunkTransfer.class);
    private final DiscoveryNode remoteNode;
    private final String restoreUUID;
    private final ShardId remoteShardId;
    private final String localClusterName;
    private final Client client;
    private final ThreadPool threadPool;
    private final ByteSizeValue chunkSize;
    private final String tempFilePrefix;
    private final MultiFileWriter multiFileWriter;
    private long offset = 0L;

    public RemoteClusterMultiChunkTransfer(Logger logger, String localClusterName, Store localStore, int maxConcurrentChunks, String restoreUUID, DiscoveryNode remoteNode, ShardId remoteShardId, List<StoreFileMetadata> remoteFiles, Client client, ThreadPool threadPool, RecoveryState recoveryState, ByteSizeValue chunkSize, ActionListener<Void> listener) {
        super(logger, listener, maxConcurrentChunks, remoteFiles);
        this.localClusterName = localClusterName;
        this.restoreUUID = restoreUUID;
        this.remoteNode = remoteNode;
        this.remoteShardId = remoteShardId;
        this.client = client;
        this.threadPool = threadPool;
        this.chunkSize = chunkSize;
        this.tempFilePrefix = RESTORE_SHARD_TEMP_FILE_PREFIX + restoreUUID + ".";
        this.multiFileWriter = new MultiFileWriter(localStore, recoveryState.getIndex(), this.tempFilePrefix, logger, () -> {});
        for (StoreFileMetadata fileMetadata : remoteFiles) {
            recoveryState.getIndex().addFileDetail(fileMetadata.name(), fileMetadata.length(), false);
        }
    }

    @Override
    protected RemoteClusterRepositoryFileChunk nextChunkRequest(StoreFileMetadata resource) throws IOException {
        RemoteClusterRepositoryFileChunk chunkReq = new RemoteClusterRepositoryFileChunk(resource, this.offset, this.chunkSize.bytesAsInt());
        this.offset += (long)this.chunkSize.bytesAsInt();
        return chunkReq;
    }

    @Override
    protected void executeChunkRequest(RemoteClusterRepositoryFileChunk request, ActionListener<Void> listener) {
        GetFileChunkAction.Request getFileChunkRequest = new GetFileChunkAction.Request(this.restoreUUID, this.remoteNode, this.remoteShardId, this.localClusterName, request.storeFileMetadata(), request.offset(), request.length());
        CompletableFuture<GetFileChunkAction.Response> fileChunkResponse = this.client.execute(GetFileChunkAction.INSTANCE, getFileChunkRequest);
        fileChunkResponse.whenComplete((response, err) -> {
            if (err == null) {
                LOGGER.debug("Filename: {}, response_size: {}, response_offset: {}", (Object)request.storeFileMetadata().name(), (Object)response.data().length(), (Object)response.offset());
                try {
                    this.threadPool.executor("snapshot").execute(() -> {
                        try {
                            this.multiFileWriter.writeFileChunk(response.storeFileMetadata(), response.offset(), response.data(), request.lastChunk());
                            listener.onResponse(null);
                        }
                        catch (IOException e) {
                            listener.onFailure(new UncheckedIOException(e));
                        }
                    });
                }
                catch (EsRejectedExecutionException e) {
                    listener.onFailure(e);
                }
            } else {
                LOGGER.error("Failed to fetch file chunk for {} with offset {}", (Object)request.storeFileMetadata().name(), (Object)request.offset(), err);
            }
        });
    }

    @Override
    protected void handleError(StoreFileMetadata resource, Exception e) throws Exception {
        LOGGER.error("Error while transferring segments ", (Throwable)e);
    }

    @Override
    protected void onNewResource(StoreFileMetadata resource) throws IOException {
        this.offset = 0L;
    }

    @Override
    public void close() throws IOException {
        this.multiFileWriter.renameAllTempFiles();
        this.multiFileWriter.close();
    }
}

