/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.data.Row;
import io.crate.session.BaseResultReceiver;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RestBulkRowCountReceiver
extends BaseResultReceiver {
    private final Result[] results;
    private final int resultIdx;
    private long rowCount;
    @Nullable
    private Throwable failure;

    RestBulkRowCountReceiver(Result[] results, int resultIdx) {
        this.results = results;
        this.resultIdx = resultIdx;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) {
        this.rowCount = (Long)row.get(0);
        try {
            this.failure = (Throwable)row.get(1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void allFinished() {
        this.results[this.resultIdx] = this.failure == null ? new Result(this.rowCount, null) : new Result(this.rowCount, this.failure);
        super.allFinished();
    }

    @Override
    public void fail(@NotNull Throwable t) {
        this.results[this.resultIdx] = new Result(this.rowCount, t);
        super.fail(t);
    }

    record Result(long rowCount, @Nullable Throwable error) {
    }
}

