/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.Policy;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class GrantedRolesChange
implements Writeable {
    private final Policy policy;
    private final Set<String> roleNames;
    private final String grantor;

    public GrantedRolesChange(Policy policy, Set<String> roleNames, String grantor) {
        this.policy = policy;
        this.roleNames = roleNames;
        this.grantor = grantor;
    }

    public GrantedRolesChange(StreamInput in) throws IOException {
        this.policy = in.readEnum(Policy.class);
        this.roleNames = in.readSet(StreamInput::readString);
        this.grantor = in.readString();
    }

    public Policy policy() {
        return this.policy;
    }

    public Set<String> roleNames() {
        return this.roleNames;
    }

    public String grantor() {
        return this.grantor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantedRolesChange that = (GrantedRolesChange)o;
        return this.policy == that.policy && Objects.equals(this.roleNames, that.roleNames);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.roleNames});
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.policy);
        out.writeCollection(this.roleNames, StreamOutput::writeString);
        out.writeString(this.grantor);
    }
}

