/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateModifier;
import io.crate.role.PrivilegesModifier;
import io.crate.role.metadata.RolesMetadata;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.jetbrains.annotations.VisibleForTesting;

public class RoleManagerDDLModifier
implements DDLClusterStateModifier {
    @Override
    public ClusterState onDropTable(ClusterState currentState, RelationName relationName) {
        return this.dropPrivilegesForTableOrView(currentState, relationName);
    }

    @Override
    public ClusterState onDropView(ClusterState currentState, List<RelationName> relationNames) {
        for (RelationName relationName : relationNames) {
            currentState = this.dropPrivilegesForTableOrView(currentState, relationName);
        }
        return currentState;
    }

    @Override
    public ClusterState onRenameTable(ClusterState currentState, RelationName sourceRelationName, RelationName targetRelationName, boolean isPartitionedTable) {
        Metadata currentMetadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
        if (RoleManagerDDLModifier.transferTablePrivileges(currentState.nodes().getMinNodeVersion(), mdBuilder, sourceRelationName, targetRelationName)) {
            return ClusterState.builder(currentState).metadata(mdBuilder).build();
        }
        return currentState;
    }

    @Override
    public ClusterState onSwapRelations(ClusterState currentState, RelationName source, RelationName target) {
        Metadata currentMetadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
        UsersPrivilegesMetadata oldPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        if (oldPrivilegesMetadata == null && oldRolesMetadata == null) {
            return currentState;
        }
        RoleManagerDDLModifier.validateMigrationToRolesMetadata(currentState.nodes().getMinNodeVersion(), "swap tables");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        RolesMetadata newMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldPrivilegesMetadata, oldRolesMetadata);
        newMetadata = PrivilegesModifier.swapPrivileges(newMetadata, source, target);
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentMetadata).putCustom("roles", newMetadata).build()).build();
    }

    private ClusterState dropPrivilegesForTableOrView(ClusterState currentState, RelationName relationName) {
        Metadata currentMetadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
        if (!RoleManagerDDLModifier.dropPrivileges(currentState.nodes().getMinNodeVersion(), mdBuilder, relationName)) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    private static boolean dropPrivileges(Version minNodeVersion, Metadata.Builder mdBuilder, RelationName relationName) {
        UsersPrivilegesMetadata oldPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        if (oldPrivilegesMetadata == null && oldRolesMetadata == null) {
            return false;
        }
        RoleManagerDDLModifier.validateMigrationToRolesMetadata(minNodeVersion, "drop tables or views");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        RolesMetadata newMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldPrivilegesMetadata, oldRolesMetadata);
        long affectedRows = PrivilegesModifier.dropTableOrViewPrivileges(mdBuilder, newMetadata, relationName.fqn());
        return affectedRows > 0L;
    }

    @VisibleForTesting
    static boolean transferTablePrivileges(Version minNodeVersion, Metadata.Builder mdBuilder, RelationName sourceRelationName, RelationName targetRelationName) {
        UsersPrivilegesMetadata oldPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        if (oldPrivilegesMetadata == null && oldRolesMetadata == null) {
            return false;
        }
        RoleManagerDDLModifier.validateMigrationToRolesMetadata(minNodeVersion, "rename tables or views");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        RolesMetadata migratedMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldPrivilegesMetadata, oldRolesMetadata);
        RolesMetadata newMetadata = PrivilegesModifier.maybeCopyAndReplaceTableIdents(migratedMetadata, sourceRelationName.fqn(), targetRelationName.fqn());
        if (newMetadata != null) {
            mdBuilder.putCustom("roles", newMetadata);
            return true;
        }
        if (!Objects.equals(oldRolesMetadata, migratedMetadata)) {
            mdBuilder.putCustom("roles", migratedMetadata);
            return true;
        }
        return false;
    }

    private static void validateMigrationToRolesMetadata(Version minNodeVersion, String msg) {
        if (!minNodeVersion.onOrAfter(Version.V_5_6_0)) {
            throw new IllegalStateException("Cannot " + msg + " until all nodes are upgraded to 5.6");
        }
    }
}

