/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.metadata.IndexName;
import io.crate.role.Permission;
import io.crate.role.Policy;
import io.crate.role.Privilege;
import io.crate.role.Securable;
import io.crate.role.Subject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RolePrivileges
implements Iterable<Privilege> {
    private final Map<Subject, Privilege> privilegeByIdent;
    private final Policy anyClusterPrivilege;
    private final Map<String, Policy> schemaPrivileges = new HashMap<String, Policy>();
    private final Map<String, Policy> tablePrivileges = new HashMap<String, Policy>();
    private final Map<String, Policy> viewPrivileges = new HashMap<String, Policy>();

    public RolePrivileges(Collection<Privilege> privileges) {
        this.privilegeByIdent = HashMap.newHashMap(privileges.size());
        Policy anyClusterPriv = Policy.REVOKE;
        block6: for (Privilege privilege : privileges) {
            Subject subject = privilege.subject();
            this.privilegeByIdent.put(subject, privilege);
            switch (subject.securable()) {
                case CLUSTER: {
                    if (anyClusterPriv == Policy.DENY) continue block6;
                    anyClusterPriv = privilege.policy();
                    continue block6;
                }
                case SCHEMA: {
                    if (this.schemaPrivileges.get(subject.ident()) == Policy.DENY) continue block6;
                    this.schemaPrivileges.put(subject.ident(), privilege.policy());
                    continue block6;
                }
                case TABLE: {
                    if (this.tablePrivileges.get(subject.ident()) == Policy.DENY) continue block6;
                    this.tablePrivileges.put(subject.ident(), privilege.policy());
                    continue block6;
                }
                case VIEW: {
                    if (this.viewPrivileges.get(subject.ident()) == Policy.DENY) continue block6;
                    this.viewPrivileges.put(subject.ident(), privilege.policy());
                    continue block6;
                }
            }
            throw new IllegalStateException("Unsupported securable=" + String.valueOf((Object)subject.securable()));
        }
        this.anyClusterPrivilege = anyClusterPriv;
    }

    public Policy matchPrivilegeOfAnyType(Securable securable, @Nullable String ident) {
        Policy resolution;
        switch (securable) {
            case CLUSTER: {
                resolution = this.hasAnyClusterPrivilege();
                break;
            }
            case SCHEMA: {
                resolution = this.hasAnySchemaPrivilege(ident);
                if (resolution != Policy.REVOKE) break;
                resolution = this.hasAnyClusterPrivilege();
                break;
            }
            case TABLE: {
                String schemaIdent;
                resolution = this.hasAnyTablePrivilege(ident);
                if (resolution != Policy.REVOKE || (resolution = this.hasAnySchemaPrivilege(schemaIdent = IndexName.decode(ident).schema())) != Policy.REVOKE) break;
                resolution = this.hasAnyClusterPrivilege();
                break;
            }
            case VIEW: {
                String schemaIdent;
                resolution = this.hasAnyViewPrivilege(ident);
                if (resolution != Policy.REVOKE || (resolution = this.hasAnySchemaPrivilege(schemaIdent = IndexName.decode(ident).schema())) != Policy.REVOKE) break;
                resolution = this.hasAnyClusterPrivilege();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported securable=" + String.valueOf((Object)securable));
            }
        }
        return resolution;
    }

    public Policy matchPrivilege(@Nullable Permission permission, Securable securable, @Nullable String ident) {
        Privilege foundPrivilege = this.privilegeByIdent.get(new Subject(permission, securable, ident));
        if (foundPrivilege == null) {
            switch (securable) {
                case SCHEMA: {
                    foundPrivilege = this.privilegeByIdent.get(new Subject(permission, Securable.CLUSTER, null));
                    break;
                }
                case TABLE: 
                case VIEW: {
                    if (ident != null) {
                        String schemaIdent = IndexName.decode(ident).schema();
                        foundPrivilege = this.privilegeByIdent.get(new Subject(permission, Securable.SCHEMA, schemaIdent));
                        if (foundPrivilege != null) break;
                        foundPrivilege = this.privilegeByIdent.get(new Subject(permission, Securable.CLUSTER, null));
                        break;
                    }
                    foundPrivilege = this.privilegeByIdent.get(new Subject(permission, Securable.CLUSTER, null));
                    break;
                }
            }
        }
        if (foundPrivilege == null) {
            return Policy.REVOKE;
        }
        return foundPrivilege.policy();
    }

    @Override
    @NotNull
    public Iterator<Privilege> iterator() {
        return this.privilegeByIdent.values().iterator();
    }

    private Policy hasAnyClusterPrivilege() {
        return this.anyClusterPrivilege;
    }

    private Policy hasAnySchemaPrivilege(String ident) {
        Policy policy = this.schemaPrivileges.get(ident);
        if (policy == null) {
            return Policy.REVOKE;
        }
        return policy;
    }

    private Policy hasAnyTablePrivilege(String ident) {
        Policy policy = this.tablePrivileges.get(ident);
        if (policy == null) {
            return Policy.REVOKE;
        }
        return policy;
    }

    private Policy hasAnyViewPrivilege(String ident) {
        Policy policy = this.viewPrivileges.get(ident);
        if (policy == null) {
            return Policy.REVOKE;
        }
        return policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolePrivileges that = (RolePrivileges)o;
        return this.privilegeByIdent.equals(that.privilegeByIdent);
    }

    public int hashCode() {
        return this.privilegeByIdent.hashCode();
    }

    public int size() {
        return this.privilegeByIdent.size();
    }
}

