/*
 * Decompiled with CFR 0.152.
 */
package io.crate.server.xcontent;

import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.ParseField;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    public static final LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ParseField.class));

    private LoggingDeprecationHandler() {
    }

    public void usedDeprecatedName(String usedName, String modernName) {
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("deprecated_field", "Deprecated field [{}] used, expected [{}] instead", usedName, modernName);
    }

    public void usedDeprecatedField(String usedName, String replacedWith) {
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("deprecated_field", "Deprecated field [{}] used, replaced by [{}]", usedName, replacedWith);
    }
}

