/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.analyze.AnalyzedBegin;
import io.crate.analyze.AnalyzedClose;
import io.crate.analyze.AnalyzedCommit;
import io.crate.analyze.AnalyzedDeallocate;
import io.crate.analyze.AnalyzedDeclare;
import io.crate.analyze.AnalyzedDiscard;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.Analyzer;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.ParameterTypes;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.auth.Protocol;
import io.crate.common.collections.Lists;
import io.crate.common.unit.TimeValue;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.RowN;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.ReadOnlyException;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dml.BulkResponse;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.jobs.kill.KillJobsNodeAction;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.Planner;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.StatementClassifier;
import io.crate.planner.operators.SubQueryResults;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.protocols.postgres.FormatCodes;
import io.crate.protocols.postgres.JobsLogsUpdateListener;
import io.crate.protocols.postgres.Portal;
import io.crate.protocols.postgres.TransactionState;
import io.crate.protocols.postgres.parser.PgArrayParser;
import io.crate.session.Cursors;
import io.crate.session.DeferredExecution;
import io.crate.session.DescribeResult;
import io.crate.session.PreparedStmt;
import io.crate.session.ResultReceiver;
import io.crate.session.RetryOnFailureResultReceiver;
import io.crate.session.RowConsumerToResultReceiver;
import io.crate.session.Sessions;
import io.crate.sql.SqlFormatter;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.Declare;
import io.crate.sql.tree.DiscardStatement;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.Statement;
import io.crate.types.DataType;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Session
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(Sessions.class);
    private static final Statement EMPTY_STMT = SqlParser.createStatement((String)"select '' from sys.cluster limit 0");
    public static final String UNNAMED = "";
    private final DependencyCarrier executor;
    private final CoordinatorSessionSettings sessionSettings;
    @VisibleForTesting
    final Map<String, PreparedStmt> preparedStatements = new HashMap<String, PreparedStmt>();
    @VisibleForTesting
    final Map<String, Portal> portals = new HashMap<String, Portal>();
    final Cursors cursors = new Cursors();
    @VisibleForTesting
    final Map<Statement, List<DeferredExecution>> deferredExecutionsByStmt = new LinkedHashMap<Statement, List<DeferredExecution>>();
    @VisibleForTesting
    @Nullable
    CompletableFuture<?> activeExecution;
    @Nullable
    private UUID mostRecentJobID;
    private final int id;
    private final ConnectionProperties connectionProperties;
    private final long timeCreated;
    private final int secret;
    private final Analyzer analyzer;
    private final Planner planner;
    private final JobsLogs jobsLogs;
    private final boolean isReadOnly;
    private final Runnable onClose;
    private final int tempErrorRetryCount;
    private TransactionState currentTransactionState = TransactionState.IDLE;
    private volatile String lastStmt;

    public Session(int sessionId, @Nullable ConnectionProperties connectionProperties, Analyzer analyzer, Planner planner, JobsLogs jobsLogs, boolean isReadOnly, DependencyCarrier executor, CoordinatorSessionSettings sessionSettings, Runnable onClose, int tempErrorRetryCount) {
        this.id = sessionId;
        this.connectionProperties = connectionProperties;
        this.timeCreated = System.currentTimeMillis();
        this.secret = ThreadLocalRandom.current().nextInt();
        this.analyzer = analyzer;
        this.planner = planner;
        this.jobsLogs = jobsLogs;
        this.isReadOnly = isReadOnly;
        this.executor = executor;
        this.sessionSettings = sessionSettings;
        this.onClose = onClose;
        this.tempErrorRetryCount = tempErrorRetryCount;
    }

    public int id() {
        return this.id;
    }

    public long timeCreated() {
        return this.timeCreated;
    }

    public boolean isSystemSession() {
        return this.connectionProperties == null;
    }

    public InetAddress clientAddress() {
        return this.connectionProperties == null ? null : this.connectionProperties.address();
    }

    public Protocol protocol() {
        return this.connectionProperties == null ? null : this.connectionProperties.protocol();
    }

    public boolean hasSSL() {
        return this.connectionProperties != null && this.connectionProperties.hasSSL();
    }

    public String lastStmt() {
        return this.lastStmt;
    }

    public int secret() {
        return this.secret;
    }

    public TimeoutToken newTimeoutToken() {
        return new TimeoutToken(this.sessionSettings.statementTimeout(), System.nanoTime());
    }

    public void quickExec(String statement, ResultReceiver<?> resultReceiver, Row params) {
        Plan plan;
        this.lastStmt = statement;
        CoordinatorTxnCtx txnCtx = new CoordinatorTxnCtx(this.sessionSettings);
        Statement parsedStmt = SqlParser.createStatement((String)statement);
        AnalyzedStatement analyzedStatement = this.analyzer.analyze(parsedStmt, this.sessionSettings, ParamTypeHints.EMPTY, this.cursors);
        RoutingProvider routingProvider = new RoutingProvider(Randomness.get().nextInt(), this.planner.getAwarenessAttributes());
        UUID jobId = this.mostRecentJobID = UUIDs.dirtyUUID();
        ClusterState clusterState = this.planner.currentClusterState();
        PlannerContext plannerContext = this.planner.createContext(routingProvider, jobId, txnCtx, 0, params, this.cursors, this.currentTransactionState, TimeoutToken.noopToken());
        try {
            plan = this.planner.plan(analyzedStatement, plannerContext);
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(jobId, statement, SQLExceptions.messageOf(t), this.sessionSettings.sessionUser());
            throw t;
        }
        StatementClassifier.Classification classification = StatementClassifier.classify(plan);
        this.jobsLogs.logExecutionStart(jobId, statement, this.sessionSettings.sessionUser(), classification);
        JobsLogsUpdateListener jobsLogsUpdateListener = new JobsLogsUpdateListener(jobId, this.jobsLogs);
        if (!analyzedStatement.isWriteOperation()) {
            resultReceiver = new RetryOnFailureResultReceiver(this.tempErrorRetryCount, this.executor.clusterService(), indexName -> clusterState.metadata().hasIndex((String)indexName), resultReceiver, jobId, (newJobId, retryResultReceiver) -> this.retryQuery((UUID)newJobId, analyzedStatement, routingProvider, new RowConsumerToResultReceiver((ResultReceiver<?>)retryResultReceiver, 0, jobsLogsUpdateListener), params, txnCtx, TimeoutToken.noopToken()));
        }
        RowConsumerToResultReceiver consumer = new RowConsumerToResultReceiver(resultReceiver, 0, jobsLogsUpdateListener);
        plan.execute(this.executor, plannerContext, consumer, params, SubQueryResults.EMPTY);
    }

    private void retryQuery(UUID jobId, AnalyzedStatement stmt, RoutingProvider routingProvider, RowConsumer consumer, Row params, CoordinatorTxnCtx txnCtx, TimeoutToken timeoutToken) {
        PlannerContext plannerContext = this.planner.createContext(routingProvider, jobId, txnCtx, 0, params, this.cursors, this.currentTransactionState, timeoutToken);
        Plan plan = this.planner.plan(stmt, plannerContext);
        if (timeoutToken != null) {
            timeoutToken.check();
        }
        plan.execute(this.executor, plannerContext, consumer, params, SubQueryResults.EMPTY);
    }

    private Portal getSafePortal(String portalName) {
        Portal portal = this.portals.get(portalName);
        if (portal == null) {
            throw new IllegalArgumentException("Cannot find portal: " + portalName);
        }
        return portal;
    }

    public CoordinatorSessionSettings sessionSettings() {
        return this.sessionSettings;
    }

    public void parse(String statementName, String query, List<DataType<?>> paramTypes) {
        Statement statement;
        TimeoutToken timeoutToken = this.newTimeoutToken();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=parse stmtName={} query={} paramTypes={}", (Object)statementName, (Object)query, paramTypes);
        }
        try {
            statement = SqlParser.createStatement((String)query);
        }
        catch (Throwable t) {
            if (UNNAMED.equals(query)) {
                statement = EMPTY_STMT;
            }
            this.jobsLogs.logPreExecutionFailure(UUIDs.dirtyUUID(), query, SQLExceptions.messageOf(t), this.sessionSettings.sessionUser());
            throw t;
        }
        timeoutToken.check();
        this.analyze(statementName, statement, paramTypes, query, timeoutToken);
    }

    public void analyze(String statementName, Statement statement, List<DataType<?>> paramTypes, @Nullable String query, TimeoutToken timeoutToken) {
        DataType[] parameterTypes;
        AnalyzedStatement analyzedStatement;
        try {
            analyzedStatement = this.analyzer.analyze(statement, this.sessionSettings, new ParamTypeHints(paramTypes), this.cursors);
            parameterTypes = ParameterTypes.extract(analyzedStatement).toArray(new DataType[0]);
            timeoutToken.check();
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(UUIDs.dirtyUUID(), query == null ? statementName : query, SQLExceptions.messageOf(t), this.sessionSettings.sessionUser());
            throw t;
        }
        this.preparedStatements.put(statementName, new PreparedStmt(statement, analyzedStatement, query, parameterTypes, timeoutToken));
    }

    public void bind(String portalName, String statementName, List<Object> params, @Nullable FormatCodes.FormatCode[] resultFormatCodes) {
        AnalyzedDeclare analyzedDeclare;
        Declare declare;
        String cursorName;
        AnalyzedStatement analyzedStatement;
        PreparedStmt preparedStmt;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=bind portalName={} statementName={} params={}", (Object)portalName, (Object)statementName, params);
        }
        try {
            preparedStmt = this.getSafeStmt(statementName);
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(UUIDs.dirtyUUID(), UNNAMED, SQLExceptions.messageOf(t), this.sessionSettings.sessionUser());
            throw t;
        }
        Portal portal = new Portal(portalName, preparedStmt, params, resultFormatCodes);
        Portal oldPortal = this.portals.put(portalName, portal);
        if (oldPortal != null) {
            oldPortal.closeActiveConsumer();
        }
        if ((analyzedStatement = preparedStmt.analyzedStatement()) instanceof AnalyzedDeclare && !(cursorName = (declare = (analyzedDeclare = (AnalyzedDeclare)analyzedStatement).declare()).cursorName()).equals(portalName)) {
            DataType[] parameterTypes = ParameterTypes.extract(analyzedDeclare.query()).toArray(new DataType[0]);
            PreparedStmt preparedQuery = new PreparedStmt((Statement)declare.query(), analyzedDeclare.query(), SqlFormatter.formatSql((Node)declare.query()), parameterTypes, preparedStmt.timeoutToken());
            Portal queryPortal = new Portal(cursorName, preparedQuery, List.of(), resultFormatCodes);
            this.portals.put(cursorName, queryPortal);
        }
    }

    public DescribeResult describe(char type, String portalOrStatement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=describe type={} portalOrStatement={}", (Object)Character.valueOf(type), (Object)portalOrStatement);
        }
        switch (type) {
            case 'P': {
                Portal portal = this.getSafePortal(portalOrStatement);
                AnalyzedStatement analyzedStmt = portal.analyzedStatement();
                return new DescribeResult(portal.preparedStmt().parameterTypes(), analyzedStmt.outputs(), this.resolveTableFromSelect(analyzedStmt));
            }
            case 'S': {
                PreparedStmt preparedStmt = this.preparedStatements.get(portalOrStatement);
                AnalyzedStatement analyzedStatement = preparedStmt.analyzedStatement();
                return new DescribeResult(preparedStmt.parameterTypes(), analyzedStatement.outputs(), this.resolveTableFromSelect(analyzedStatement));
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + type));
    }

    @Nullable
    private RelationInfo resolveTableFromSelect(AnalyzedStatement stmt) {
        QueriedSelectRelation qsr;
        List<AnalyzedRelation> from;
        if (stmt instanceof QueriedSelectRelation && (from = (qsr = (QueriedSelectRelation)stmt).from()).size() == 1 && from.get(0) instanceof AbstractTableRelation) {
            return ((AbstractTableRelation)from.get(0)).tableInfo();
        }
        return null;
    }

    @Nullable
    public CompletableFuture<?> execute(String portalName, int maxRows, ResultReceiver<?> resultReceiver) {
        Portal portal;
        RowConsumerToResultReceiver activeConsumer;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=execute portalName={} maxRows={}", (Object)portalName, (Object)maxRows);
        }
        if ((activeConsumer = (portal = this.getSafePortal(portalName)).activeConsumer()) != null && activeConsumer.suspended()) {
            activeConsumer.replaceResultReceiver(resultReceiver, maxRows);
            activeConsumer.resume();
            return resultReceiver.completionFuture();
        }
        AnalyzedStatement analyzedStmt = portal.analyzedStatement();
        if (this.isReadOnly && analyzedStmt.isWriteOperation()) {
            throw new ReadOnlyException(portal.preparedStmt().rawStatement());
        }
        if (analyzedStmt instanceof AnalyzedBegin) {
            this.currentTransactionState = TransactionState.IN_TRANSACTION;
            resultReceiver.allFinished();
        } else {
            if (analyzedStmt instanceof AnalyzedCommit) {
                this.currentTransactionState = TransactionState.IDLE;
                this.cursors.close(cursor -> cursor.hold() == Declare.Hold.WITHOUT);
                resultReceiver.allFinished();
                return resultReceiver.completionFuture();
            }
            if (analyzedStmt instanceof AnalyzedDeallocate) {
                AnalyzedDeallocate ad = (AnalyzedDeallocate)analyzedStmt;
                String stmtToDeallocate = ad.preparedStmtName();
                if (stmtToDeallocate != null) {
                    this.close((byte)83, stmtToDeallocate);
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("deallocating all prepared statements");
                    }
                    this.preparedStatements.clear();
                }
                resultReceiver.allFinished();
            } else if (analyzedStmt instanceof AnalyzedDiscard) {
                AnalyzedDiscard discard = (AnalyzedDiscard)analyzedStmt;
                if (discard.target() == DiscardStatement.Target.ALL) {
                    this.close();
                }
                resultReceiver.allFinished();
            } else {
                Portal removedPortal;
                AnalyzedClose close;
                String cursorName;
                if (analyzedStmt.isWriteOperation()) {
                    this.deferredExecutionsByStmt.compute(portal.preparedStmt().parsedStatement(), (key, oldValue) -> {
                        DeferredExecution deferredExecution = new DeferredExecution(portal, maxRows, resultReceiver);
                        if (oldValue == null) {
                            ArrayList<DeferredExecution> deferredExecutions = new ArrayList<DeferredExecution>();
                            deferredExecutions.add(deferredExecution);
                            return deferredExecutions;
                        }
                        oldValue.add(deferredExecution);
                        return oldValue;
                    });
                    return resultReceiver.completionFuture();
                }
                if (analyzedStmt instanceof AnalyzedClose && (cursorName = (close = (AnalyzedClose)analyzedStmt).cursorName()) != null && (removedPortal = this.portals.remove(cursorName)) != null) {
                    removedPortal.closeActiveConsumer();
                }
                if (!this.deferredExecutionsByStmt.isEmpty()) {
                    throw new UnsupportedOperationException("Only write operations are allowed in Batch statements");
                }
                this.activeExecution = this.activeExecution == null ? this.singleExec(portal, resultReceiver, maxRows) : this.activeExecution.thenCompose(ignored -> this.singleExec(portal, resultReceiver, maxRows));
                return this.activeExecution;
            }
        }
        return null;
    }

    public void flush() {
        assert (!this.deferredExecutionsByStmt.isEmpty()) : "Session.flush() must only be called if there are deferred executions";
        this.activeExecution = this.triggerDeferredExecutions(false);
    }

    public CompletableFuture<?> sync(boolean forceBulk) {
        if (this.activeExecution == null) {
            return this.triggerDeferredExecutions(forceBulk);
        }
        CompletableFuture<?> result = this.activeExecution;
        this.activeExecution = null;
        return result;
    }

    public List<Statement> simpleQuery(String queryString) {
        try {
            return SqlParser.createStatementsForSimpleQuery((String)queryString, str -> PgArrayParser.parse((String)str, bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)));
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(UUIDs.dirtyUUID(), queryString, SQLExceptions.messageOf(t), this.sessionSettings.sessionUser());
            throw t;
        }
    }

    private void addStatementTimeout(CompletableFuture<?> result, TimeoutToken timeoutToken) {
        long durationNs = timeoutToken.disable();
        TimeValue timeout = this.sessionSettings.statementTimeout();
        UUID jobId = this.mostRecentJobID;
        long timeoutNanos = timeout.nanos();
        if (jobId == null || timeoutNanos <= 0L) {
            return;
        }
        long remainingTimeoutMs = (long)((double)(timeoutNanos - durationNs) * 1.0E-6);
        assert (remainingTimeoutMs > 0L) : "Execute must have positive timeout if timeout was not exceeded on previous phases.";
        Runnable kill = () -> {
            if (result.isDone()) {
                return;
            }
            KillJobsNodeRequest request = new KillJobsNodeRequest(List.of(), List.of(jobId), this.sessionSettings.userName(), "statement_timeout (" + timeout.toString() + ")");
            this.executor.client().execute(KillJobsNodeAction.INSTANCE, request);
        };
        ScheduledExecutorService scheduler = this.executor.scheduler();
        ScheduledFuture<?> schedule = scheduler.schedule(kill, remainingTimeoutMs, TimeUnit.MILLISECONDS);
        result.whenComplete((object, throwable) -> schedule.cancel(false));
    }

    private CompletableFuture<?> triggerDeferredExecutions(boolean forceBulk) {
        switch (this.deferredExecutionsByStmt.size()) {
            case 0: {
                LOGGER.debug("method=sync deferredExecutions=0");
                return CompletableFuture.completedFuture(null);
            }
            case 1: {
                List<DeferredExecution> deferredExecutions = this.deferredExecutionsByStmt.values().iterator().next();
                this.deferredExecutionsByStmt.clear();
                return this.exec(deferredExecutions, forceBulk);
            }
        }
        CompletionStage<Object> allCompleted = null;
        for (Map.Entry<Statement, List<DeferredExecution>> entry : this.deferredExecutionsByStmt.entrySet()) {
            List<DeferredExecution> deferredExecutions = entry.getValue();
            if (allCompleted == null) {
                allCompleted = this.exec(deferredExecutions, forceBulk);
                continue;
            }
            allCompleted = ((CompletableFuture)allCompleted.exceptionally(throwable -> null)).thenCompose(object -> this.exec(deferredExecutions, forceBulk));
        }
        this.deferredExecutionsByStmt.clear();
        return allCompleted;
    }

    private CompletableFuture<?> exec(List<DeferredExecution> executions, boolean forceBulk) {
        if (executions.size() == 1 && !forceBulk) {
            DeferredExecution toExec = executions.get(0);
            return this.singleExec(toExec.portal(), toExec.resultReceiver(), toExec.maxRows());
        }
        return this.bulkExec(executions);
    }

    private CompletableFuture<?> bulkExec(List<DeferredExecution> toExec) {
        Plan plan;
        assert (!toExec.isEmpty()) : "Must have at least 1 deferred execution for bulk exec";
        UUID jobId = this.mostRecentJobID = UUIDs.dirtyUUID();
        RoutingProvider routingProvider = new RoutingProvider(Randomness.get().nextInt(), this.planner.getAwarenessAttributes());
        CoordinatorTxnCtx txnCtx = new CoordinatorTxnCtx(this.sessionSettings);
        PreparedStmt firstPreparedStatement = toExec.get(0).portal().preparedStmt();
        TimeoutToken timeoutToken = firstPreparedStatement.timeoutToken();
        timeoutToken.enable();
        PlannerContext plannerContext = this.planner.createContext(routingProvider, jobId, txnCtx, 0, null, this.cursors, this.currentTransactionState, timeoutToken);
        AnalyzedStatement analyzedStatement = firstPreparedStatement.analyzedStatement();
        this.lastStmt = firstPreparedStatement.rawStatement();
        try {
            plan = this.planner.plan(analyzedStatement, plannerContext);
            timeoutToken.check();
        }
        catch (Throwable t2) {
            this.jobsLogs.logPreExecutionFailure(jobId, firstPreparedStatement.rawStatement(), SQLExceptions.messageOf(t2), this.sessionSettings.sessionUser());
            throw t2;
        }
        this.jobsLogs.logExecutionStart(jobId, firstPreparedStatement.rawStatement(), this.sessionSettings.sessionUser(), StatementClassifier.classify(plan));
        List bulkArgs = Lists.map(toExec, x -> new RowN(x.portal().params().toArray()));
        CompletableFuture<BulkResponse> result = plan.executeBulk(this.executor, plannerContext, bulkArgs, SubQueryResults.EMPTY);
        List resultReceiverFutures = Lists.map(toExec, x -> x.resultReceiver().completionFuture());
        CompletableFuture<Void> allResultReceivers = CompletableFuture.allOf(resultReceiverFutures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)result.thenAccept(bulkResp -> Session.emitRowCountsToResultReceivers(jobId, this.jobsLogs, toExec, bulkResp))).exceptionally(t -> {
            for (int i = 0; i < toExec.size(); ++i) {
                ((DeferredExecution)toExec.get(i)).resultReceiver().fail((Throwable)t);
            }
            this.jobsLogs.logExecutionEnd(jobId, SQLExceptions.messageOf(t));
            return null;
        });
        this.addStatementTimeout(result, timeoutToken);
        return result.runAfterBoth(allResultReceivers, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emitRowCountsToResultReceivers(UUID jobId, JobsLogs jobsLogs, List<DeferredExecution> executions, BulkResponse bulkResponse) {
        Object[] cells = new Object[2];
        RowN row = new RowN(cells);
        for (int i = 0; i < bulkResponse.size(); ++i) {
            ResultReceiver<?> resultReceiver = executions.get(i).resultReceiver();
            try {
                cells[0] = bulkResponse.rowCount(i);
                cells[1] = bulkResponse.failure(i);
            }
            catch (Throwable t) {
                cells[0] = -2L;
                cells[1] = t;
            }
            try {
                resultReceiver.setNextRow((Row)row);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                resultReceiver.allFinished();
            }
        }
        jobsLogs.logExecutionEnd(jobId, null);
    }

    @VisibleForTesting
    CompletableFuture<?> singleExec(Portal portal, ResultReceiver<?> resultReceiver, int maxRows) {
        Plan plan;
        String rawStatement;
        RowConsumerToResultReceiver activeConsumer = portal.activeConsumer();
        if (activeConsumer != null) {
            activeConsumer.closeAndFinishIfSuspended();
            return activeConsumer.completionFuture();
        }
        UUID jobId = this.mostRecentJobID = UUIDs.dirtyUUID();
        RoutingProvider routingProvider = new RoutingProvider(Randomness.get().nextInt(), this.planner.getAwarenessAttributes());
        CoordinatorTxnCtx txnCtx = new CoordinatorTxnCtx(this.sessionSettings);
        RowN params = new RowN(portal.params().toArray());
        TimeoutToken timeoutToken = portal.preparedStmt().timeoutToken();
        timeoutToken.enable();
        PlannerContext plannerContext = this.planner.createContext(routingProvider, jobId, txnCtx, maxRows, (Row)params, this.cursors, this.currentTransactionState, timeoutToken);
        AnalyzedStatement analyzedStmt = portal.analyzedStatement();
        this.lastStmt = rawStatement = portal.preparedStmt().rawStatement();
        if (analyzedStmt == null) {
            String errorMsg = "Statement must have been analyzed: " + rawStatement;
            this.jobsLogs.logPreExecutionFailure(jobId, rawStatement, errorMsg, this.sessionSettings.sessionUser());
            throw new IllegalStateException(errorMsg);
        }
        try {
            plan = this.planner.plan(analyzedStmt, plannerContext);
            timeoutToken.check();
        }
        catch (Throwable t) {
            this.jobsLogs.logPreExecutionFailure(jobId, rawStatement, SQLExceptions.messageOf(t), this.sessionSettings.sessionUser());
            throw t;
        }
        if (!analyzedStmt.isWriteOperation()) {
            resultReceiver = new RetryOnFailureResultReceiver(this.tempErrorRetryCount, this.executor.clusterService(), indexName -> this.executor.clusterService().state().metadata().hasIndex((String)indexName), resultReceiver, jobId, (newJobId, resultRec) -> this.retryQuery((UUID)newJobId, analyzedStmt, routingProvider, new RowConsumerToResultReceiver((ResultReceiver<?>)resultRec, maxRows, new JobsLogsUpdateListener((UUID)newJobId, this.jobsLogs)), (Row)params, txnCtx, timeoutToken));
        }
        this.jobsLogs.logExecutionStart(jobId, rawStatement, this.sessionSettings.sessionUser(), StatementClassifier.classify(plan));
        RowConsumerToResultReceiver consumer = new RowConsumerToResultReceiver(resultReceiver, maxRows, new JobsLogsUpdateListener(jobId, this.jobsLogs));
        portal.setActiveConsumer(consumer);
        plan.execute(this.executor, plannerContext, consumer, (Row)params, SubQueryResults.EMPTY);
        CompletableFuture result = resultReceiver.completionFuture();
        this.addStatementTimeout(result, timeoutToken);
        return result;
    }

    @Nullable
    public List<? extends DataType<?>> getOutputTypes(String portalName) {
        Portal portal = this.getSafePortal(portalName);
        AnalyzedStatement analyzedStatement = portal.analyzedStatement();
        List<Symbol> fields = analyzedStatement.outputs();
        if (fields != null) {
            return Symbols.typeView(fields);
        }
        return null;
    }

    public String getQuery(String portalName) {
        return this.getSafePortal(portalName).preparedStmt().rawStatement();
    }

    public DataType<?> getParamType(String statementName, int idx) {
        PreparedStmt stmt = this.getSafeStmt(statementName);
        return stmt.getEffectiveParameterType(idx);
    }

    private PreparedStmt getSafeStmt(String statementName) {
        PreparedStmt preparedStmt = this.preparedStatements.get(statementName);
        if (preparedStmt == null) {
            throw new IllegalArgumentException("No statement found with name: " + statementName);
        }
        return preparedStmt;
    }

    @Nullable
    public FormatCodes.FormatCode[] getResultFormatCodes(String portal) {
        return this.getSafePortal(portal).resultFormatCodes();
    }

    public void close(byte type, String name) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("method=close type={} name={}", (Object)Character.valueOf((char)type), (Object)name);
        }
        switch (type) {
            case 80: {
                Portal portal = this.portals.remove(name);
                if (portal != null) {
                    portal.closeActiveConsumer();
                }
                return;
            }
            case 83: {
                PreparedStmt preparedStmt = this.preparedStatements.remove(name);
                if (preparedStmt != null) {
                    Iterator<Map.Entry<String, Portal>> it = this.portals.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, Portal> entry = it.next();
                        Portal portal = entry.getValue();
                        if (!portal.preparedStmt().equals(preparedStmt)) continue;
                        portal.closeActiveConsumer();
                        it.remove();
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type + ", valid types are: [P, S]");
    }

    @Override
    public void close() {
        this.currentTransactionState = TransactionState.IDLE;
        this.resetDeferredExecutions();
        this.activeExecution = null;
        for (Portal portal : this.portals.values()) {
            portal.closeActiveConsumer();
        }
        this.portals.clear();
        this.preparedStatements.clear();
        this.cursors.close(c -> true);
        this.onClose.run();
    }

    public boolean hasDeferredExecutions() {
        return !this.deferredExecutionsByStmt.isEmpty();
    }

    public void resetDeferredExecutions() {
        for (List<DeferredExecution> deferredExecutions : this.deferredExecutionsByStmt.values()) {
            for (DeferredExecution deferredExecution : deferredExecutions) {
                deferredExecution.portal().closeActiveConsumer();
                this.portals.remove(deferredExecution.portal().name());
            }
        }
        this.deferredExecutionsByStmt.clear();
    }

    public TransactionState transactionState() {
        return this.currentTransactionState;
    }

    @Nullable
    public UUID getMostRecentJobID() {
        return this.mostRecentJobID;
    }

    public void cancelCurrentJob() {
        if (this.mostRecentJobID == null) {
            return;
        }
        KillJobsNodeRequest request = new KillJobsNodeRequest(List.of(), List.of(this.mostRecentJobID), this.sessionSettings.userName(), "Cancellation request by: " + this.sessionSettings.userName());
        this.executor.client().execute(KillJobsNodeAction.INSTANCE, request);
        this.resetDeferredExecutions();
    }

    public String toString() {
        return "Session{, mostRecentJobID=" + String.valueOf(this.mostRecentJobID) + ", id=" + this.id + "}";
    }

    public static class TimeoutToken {
        protected TimeValue statementTimeout;
        private long startNanos;
        private boolean enabled = true;

        public TimeoutToken(TimeValue statementTimeout, long startNanos) {
            this.statementTimeout = statementTimeout;
            this.startNanos = startNanos;
        }

        public static TimeoutToken noopToken() {
            return new TimeoutToken();
        }

        private TimeoutToken() {
            this.enabled = false;
        }

        public void check() {
            long durationNs;
            if (this.enabled && this.statementTimeout.nanos() > 0L && (durationNs = System.nanoTime() - this.startNanos) > this.statementTimeout.nanos()) {
                throw JobKilledException.of("statement_timeout (" + String.valueOf(this.statementTimeout) + ")");
            }
        }

        public long disable() {
            this.enabled = false;
            return System.nanoTime() - this.startNanos;
        }

        public void enable() {
            if (!this.enabled) {
                this.startNanos = System.nanoTime();
                this.enabled = true;
            }
        }
    }
}

