/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public final class FetchSampleRequest
extends TransportRequest {
    private final RelationName relationName;
    private final List<Reference> columns;

    public FetchSampleRequest(RelationName relationName, List<Reference> columns, Version nodeVersion) {
        this.relationName = relationName;
        this.columns = columns;
        if (nodeVersion.before(Version.V_5_7_0)) {
            throw new UnsupportedOperationException("Cannot run ANALYZE request in a mixed cluster with nodes older than 5.7.0");
        }
    }

    public FetchSampleRequest(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_5_7_0)) {
            throw new UnsupportedOperationException("Cannot run ANALYZE request in a mixed cluster with nodes older than 5.7.0");
        }
        this.relationName = new RelationName(in);
        if (in.getVersion().before(Version.V_5_7_0)) {
            in.readVInt();
        }
        int numColumns = in.readVInt();
        this.columns = new ArrayList<Reference>(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            this.columns.add((Reference)Reference.fromStream(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.relationName.writeTo(out);
        if (out.getVersion().before(Version.V_5_7_0)) {
            out.writeVInt(30000);
        }
        out.writeVInt(this.columns.size());
        for (Reference column : this.columns) {
            Reference.toStream(out, column);
        }
    }

    public RelationName relation() {
        return this.relationName;
    }

    public List<Reference> columns() {
        return this.columns;
    }

    public int hashCode() {
        return Objects.hash(this.relationName, this.columns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FetchSampleRequest)) {
            return false;
        }
        FetchSampleRequest other = (FetchSampleRequest)obj;
        return this.relationName.equals(other.relation()) && this.columns.equals(other.columns());
    }
}

