/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.statistics.MostCommonValues;
import io.crate.statistics.SketchStreamer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MostCommonValuesSketch<T> {
    private static final int MAX_VALUES = 100;
    private final ItemsSketch<T> sketch;
    private final SketchStreamer<T> streamer;

    public MostCommonValuesSketch(Streamer<T> streamer) {
        this.streamer = new SketchStreamer<T>(streamer);
        this.sketch = new ItemsSketch(256);
    }

    public MostCommonValuesSketch(Streamer<T> streamer, StreamInput in) throws IOException {
        this.streamer = new SketchStreamer<T>(streamer);
        byte[] bytes = in.readByteArray();
        this.sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes), this.streamer);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.sketch.toByteArray(this.streamer));
    }

    public MostCommonValuesSketch<T> merge(MostCommonValuesSketch<?> other) {
        ItemsSketch<T> otherSketch = other.sketch;
        this.sketch.merge(otherSketch);
        return this;
    }

    public void update(T value) {
        this.sketch.update(value);
    }

    public MostCommonValues<T> toMostCommonValues(long valueCount, double approxDistinct) {
        return this.toMostCommonValues(valueCount, approxDistinct, Function.identity());
    }

    public <R> MostCommonValues<R> toMostCommonValues(long valueCount, double approxDistinct, Function<T, R> converter) {
        ItemsSketch.Row[] rows = this.sketch.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
        int count = Math.min(100, rows.length);
        long[] counts = new long[count];
        List<Object> values = new ArrayList<R>();
        for (int i = 0; i < count; ++i) {
            counts[i] = rows[i].getLowerBound();
            values.add(converter.apply(rows[i].getItem()));
        }
        if (approxDistinct < 100.0) {
            return new MostCommonValues(values, MostCommonValuesSketch.toFreqs(counts, valueCount));
        }
        int cutoff = MostCommonValuesSketch.cutoff(this.sketch.getStreamLength(), approxDistinct, counts);
        values = values.subList(0, cutoff);
        counts = Arrays.copyOf(counts, cutoff);
        return new MostCommonValues(values, MostCommonValuesSketch.toFreqs(counts, valueCount));
    }

    private static double[] toFreqs(long[] counts, long valueCount) {
        double[] freqs = new double[counts.length];
        for (int i = 0; i < freqs.length; ++i) {
            freqs[i] = (double)counts[i] / (double)valueCount;
        }
        return freqs;
    }

    private static int cutoff(long valueCount, double approxDistinct, long[] counts) {
        int cutoff = counts.length;
        long sumFreq = 0L;
        for (int i = 0; i < counts.length - 1; ++i) {
            sumFreq += counts[i];
        }
        while (cutoff > 0) {
            double selectivity = 1.0 - (double)sumFreq / (double)valueCount;
            selectivity = Math.max(0.0, Math.min(1.0, selectivity));
            double otherDistinct = approxDistinct - (double)cutoff + 1.0;
            if (otherDistinct > 1.0) {
                selectivity /= otherDistinct;
            }
            if ((double)counts[cutoff - 1] > (selectivity *= (double)valueCount + 0.5) || --cutoff == 0) break;
            sumFreq -= counts[cutoff - 1];
        }
        return cutoff;
    }
}

