/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import com.fasterxml.jackson.core.Base64Variants;
import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.execution.dml.BitStringIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.tree.BitString;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public final class BitStringType
extends DataType<BitString>
implements Streamer<BitString>,
FixedWidthType {
    public static final int ID = 25;
    public static final BitStringType INSTANCE_ONE = new BitStringType(1);
    public static final String NAME = "bit";
    public static final int DEFAULT_LENGTH = 1;
    private final int length;
    private static final StorageSupport<BitString> STORAGE = new StorageSupport<BitString>(true, false, (EqQuery)new EqQuery<BitString>(){

        @Override
        public Query termQuery(String field, BitString value, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermQuery(new Term(field, new BytesRef(value.bitSet().toByteArray())));
            }
            assert (hasDocValues) : "hasDocValues must be true for BitString types since 'columnstore=false' is not supported.";
            return SortedSetDocValuesField.newSlowExactQuery((String)field, (BytesRef)new BytesRef(value.bitSet().toByteArray()));
        }

        @Override
        public Query rangeQuery(String field, BitString lowerTerm, BitString upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            return null;
        }

        @Override
        public Query termsQuery(String field, List<BitString> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermInSetQuery(field, nonNullValues.stream().map(v -> new BytesRef(v.bitSet().toByteArray())).toList());
            }
            assert (hasDocValues) : "hasDocValues must be true for BitString types since 'columnstore=false' is not supported.";
            return SortedSetDocValuesField.newSlowSetQuery((String)field, (Collection)Lists.map(nonNullValues, v -> new BytesRef(v.bitSet().toByteArray())));
        }
    }){

        @Override
        public ValueIndexer<BitString> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new BitStringIndexer(ref);
        }
    };

    public BitStringType(StreamInput in) throws IOException {
        this.length = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.length);
    }

    public BitStringType(int length) {
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        return List.of(DataTypes.INTEGER);
    }

    @Override
    public TypeSignature getTypeSignature() {
        if (this.length == 1) {
            return new TypeSignature(NAME);
        }
        return new TypeSignature(this.getName(), List.of(TypeSignature.of(this.length)));
    }

    @Override
    public int compare(BitString o1, BitString o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int id() {
        return 25;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.CUSTOM;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<BitString> streamer() {
        return this;
    }

    @Override
    public BitString sanitizeValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return new BitString(BitSet.valueOf(Base64Variants.MIME_NO_LINEFEEDS.decode(str)), this.length);
        }
        return (BitString)value;
    }

    @Override
    public BitString explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        if (value instanceof String) {
            String str = (String)value;
            return BitString.ofRawBits((String)str, (int)this.length);
        }
        BitString bs = (BitString)value;
        if (bs.length() == this.length) {
            return bs;
        }
        return new BitString(bs.bitSet().get(0, this.length), this.length);
    }

    @Override
    public BitString implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value instanceof String) {
            String str = (String)value;
            return BitString.ofRawBits((String)str, (int)str.length());
        }
        return (BitString)value;
    }

    @Override
    public BitString valueForInsert(BitString bitString) {
        if (bitString == null) {
            return null;
        }
        if (bitString.length() == this.length) {
            return bitString;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "bit string length %d does not match type bit(%d)", bitString.length(), this.length));
    }

    @Override
    public BitString readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return new BitString(BitSet.valueOf(in.readByteArray()), in.readVInt());
        }
        return null;
    }

    @Override
    public void writeValueTo(StreamOutput out, BitString v) throws IOException {
        if (v == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByteArray(v.bitSet().toByteArray());
            out.writeVInt(v.length());
        }
    }

    @Override
    public int fixedSize() {
        return (int)Math.floor((double)this.length / 8.0);
    }

    @Override
    public long valueBytes(BitString value) {
        return (long)Math.floor((double)this.length / 8.0);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitStringType other = (BitStringType)obj;
        return this.length == other.length;
    }

    @Override
    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        return new ColumnType(this.getName(), List.of(Integer.valueOf(this.length)));
    }

    @Override
    public StorageSupport<BitString> storageSupport() {
        return STORAGE;
    }

    @Override
    public Integer characterMaximumLength() {
        return this.length();
    }

    @Override
    public void addMappingOptions(Map<String, Object> mapping) {
        mapping.put("length", this.length);
    }
}

