/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.Regproc;
import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class RegprocType
extends DataType<Regproc>
implements Streamer<Regproc> {
    public static final RegprocType INSTANCE = new RegprocType();
    public static final int ID = 19;

    @Override
    public int id() {
        return 19;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.REGPROC;
    }

    @Override
    public String getName() {
        return "regproc";
    }

    @Override
    public Streamer<Regproc> streamer() {
        return this;
    }

    @Override
    public Regproc implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            Integer num = (Integer)value;
            return Regproc.of(num, value.toString());
        }
        if (value instanceof Long) {
            Long num = (Long)value;
            if (num > Integer.MAX_VALUE || num < Integer.MIN_VALUE) {
                throw new IllegalArgumentException(String.valueOf(value) + " is outside of `int` range and cannot be cast to the regproc type");
            }
            return Regproc.of(num.intValue(), value.toString());
        }
        if (value instanceof String) {
            String str = (String)value;
            return Regproc.of(str);
        }
        if (value instanceof Regproc) {
            Regproc regproc = (Regproc)value;
            return regproc;
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Regproc valueForInsert(Regproc value) {
        throw new UnsupportedOperationException(this.getName() + " cannot be used in insert statements.");
    }

    @Override
    public Regproc sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        return (Regproc)value;
    }

    @Override
    public int compare(Regproc val1, Regproc val2) {
        return Integer.compare(val1.oid(), val2.oid());
    }

    @Override
    public Regproc readValueFrom(StreamInput in) throws IOException {
        return Regproc.of(in.readInt(), in.readString());
    }

    @Override
    public void writeValueTo(StreamOutput out, Regproc v) throws IOException {
        out.writeInt(v.oid());
        out.writeString(v.name());
    }

    @Override
    public long valueBytes(Regproc value) {
        if (value == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        return RamUsageEstimator.sizeOf((String)value.name()) + RamUsageEstimator.sizeOf((Integer)value.oid());
    }
}

