/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.signatures.antlr.TypeSignaturesBaseVisitor;
import io.crate.signatures.antlr.TypeSignaturesParser;
import io.crate.types.DataTypes;
import io.crate.types.IntegerLiteralTypeSignature;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.TimestampType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.Nullable;

class TypeSignaturesASTVisitor
extends TypeSignaturesBaseVisitor<TypeSignature> {
    TypeSignaturesASTVisitor() {
    }

    @Override
    public TypeSignature visitDoublePrecision(TypeSignaturesParser.DoublePrecisionContext context) {
        return new TypeSignature(DataTypes.DOUBLE.getName(), List.of());
    }

    @Override
    public TypeSignature visitTimeStampWithoutTimeZone(TypeSignaturesParser.TimeStampWithoutTimeZoneContext context) {
        return new TypeSignature(TimestampType.INSTANCE_WITHOUT_TZ.getName(), List.of());
    }

    @Override
    public TypeSignature visitTimeStampWithTimeZone(TypeSignaturesParser.TimeStampWithTimeZoneContext context) {
        return new TypeSignature(TimestampType.INSTANCE_WITH_TZ.getName(), List.of());
    }

    @Override
    public TypeSignature visitTimeWithTimeZone(TypeSignaturesParser.TimeWithTimeZoneContext context) {
        return new TypeSignature("time with time zone", List.of());
    }

    @Override
    public TypeSignature visitArray(TypeSignaturesParser.ArrayContext context) {
        TypeSignature parameter = this.visitOptionalContext(context.type());
        List<TypeSignature> parameters = parameter == null ? List.of() : List.of(parameter);
        return new TypeSignature("array", parameters);
    }

    @Override
    public TypeSignature visitObject(TypeSignaturesParser.ObjectContext context) {
        return new TypeSignature("object", this.getParameters(context.parameters()));
    }

    @Override
    public TypeSignature visitGeneric(TypeSignaturesParser.GenericContext context) {
        return new TypeSignature(this.getIdentifier(context.identifier()), this.getParameters(context.parameters()));
    }

    @Override
    public TypeSignature visitRow(TypeSignaturesParser.RowContext context) {
        return new TypeSignature("record", this.getParameters(context.parameters()));
    }

    @Override
    public TypeSignature visitParameter(TypeSignaturesParser.ParameterContext context) {
        if (context.INTEGER_VALUE() != null) {
            return new IntegerLiteralTypeSignature(Integer.parseInt(context.INTEGER_VALUE().getText()));
        }
        if (context.identifier() != null) {
            return new ParameterTypeSignature(this.getIdentifier(context.identifier()), this.visitOptionalContext(context.type()));
        }
        return (TypeSignature)this.visit((ParseTree)context.type());
    }

    @Nullable
    private String getIdentifier(@Nullable TypeSignaturesParser.IdentifierContext context) {
        if (context != null) {
            if (context.QUOTED_INDENTIFIER() != null) {
                String token = context.QUOTED_INDENTIFIER().getText();
                return token.substring(1, token.length() - 1);
            }
            if (context.UNQUOTED_INDENTIFIER() != null) {
                return context.UNQUOTED_INDENTIFIER().getText();
            }
        }
        return null;
    }

    @Nullable
    private TypeSignature visitOptionalContext(@Nullable TypeSignaturesParser.TypeContext context) {
        if (context != null) {
            return (TypeSignature)this.visit((ParseTree)context);
        }
        return null;
    }

    private List<TypeSignature> getParameters(@Nullable TypeSignaturesParser.ParametersContext context) {
        if (context == null || context.parameter().isEmpty()) {
            return List.of();
        }
        ArrayList<TypeSignature> result = new ArrayList<TypeSignature>(context.parameter().size());
        for (TypeSignaturesParser.ParameterContext p : context.parameter()) {
            result.add(p.accept(this));
        }
        return result;
    }
}

