/*
 * Decompiled with CFR 0.152.
 */
package io.crate.udc.ping;

import io.crate.common.unit.TimeValue;
import io.crate.monitor.ExtendedNodeInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.Nullable;

public class PingTask
extends TimerTask {
    private static final TimeValue HTTP_TIMEOUT = new TimeValue(5L, TimeUnit.SECONDS);
    private static final Logger LOGGER = LogManager.getLogger(PingTask.class);
    private final ClusterService clusterService;
    private final ExtendedNodeInfo extendedNodeInfo;
    private final String pingUrl;
    private final AtomicLong successCounter = new AtomicLong(0L);
    private final AtomicLong failCounter = new AtomicLong(0L);

    public PingTask(ClusterService clusterService, ExtendedNodeInfo extendedNodeInfo, String pingUrl) {
        this.clusterService = clusterService;
        this.pingUrl = pingUrl;
        this.extendedNodeInfo = extendedNodeInfo;
    }

    private Map<String, String> getKernelData() {
        return this.extendedNodeInfo.kernelData();
    }

    private String getClusterId() {
        return this.clusterService.state().metadata().clusterUUID();
    }

    private Boolean isMasterNode() {
        return this.clusterService.state().nodes().isLocalNodeElectedMaster();
    }

    private Map<String, Object> getCounters() {
        return Map.of("success", this.successCounter.get(), "failure", this.failCounter.get());
    }

    @Nullable
    String getHardwareAddress() {
        String macAddress = this.extendedNodeInfo.networkInfo().primaryInterface().macAddress();
        return macAddress.isEmpty() ? null : macAddress;
    }

    private URL buildPingUrl() throws URISyntaxException, IOException {
        URI uri = new URI(this.pingUrl);
        HashMap<String, String> queryMap = new HashMap<String, String>(14);
        queryMap.put("cluster_id", this.getClusterId());
        queryMap.put("kernel", Strings.toString(JsonXContent.builder().map(this.getKernelData())));
        queryMap.put("master", this.isMasterNode().toString());
        queryMap.put("ping_count", Strings.toString(JsonXContent.builder().map(this.getCounters())));
        queryMap.put("hardware_address", this.getHardwareAddress());
        queryMap.put("num_processors", Integer.toString(Runtime.getRuntime().availableProcessors()));
        queryMap.put("crate_version", Version.CURRENT.externalNumber());
        queryMap.put("java_version", System.getProperty("java.version"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending data: {}", queryMap);
        }
        ArrayList<CallSite> params = new ArrayList<CallSite>(queryMap.size());
        for (Map.Entry entry : queryMap.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            params.add((CallSite)((Object)((String)entry.getKey() + "=" + value)));
        }
        String query = String.join((CharSequence)"&", params);
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment()).toURL();
    }

    @Override
    public void run() {
        try {
            URL url = this.buildPingUrl();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending UDC information to {}...", (Object)url);
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout((int)HTTP_TIMEOUT.millis());
            conn.setReadTimeout((int)HTTP_TIMEOUT.millis());
            if (conn.getResponseCode() >= 300) {
                throw new Exception(String.format(Locale.ENGLISH, "%s Responded with Code %d", url.getHost(), conn.getResponseCode()));
            }
            if (LOGGER.isDebugEnabled()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                String line = reader.readLine();
                while (line != null) {
                    LOGGER.debug(line);
                    line = reader.readLine();
                }
                reader.close();
            } else {
                conn.getInputStream().close();
            }
            this.successCounter.incrementAndGet();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error sending UDC information", (Throwable)e);
            }
            this.failCounter.incrementAndGet();
        }
    }
}

