/*
 * Decompiled with CFR 0.152.
 */
package io.crate.udc.service;

import io.crate.common.unit.TimeValue;
import io.crate.monitor.ExtendedNodeInfo;
import io.crate.types.DataTypes;
import io.crate.udc.ping.PingTask;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class UDCService
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(UDCService.class);
    public static final Setting<Boolean> UDC_ENABLED_SETTING = Setting.boolSetting("udc.enabled", true, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<String> UDC_URL_SETTING = new Setting("udc.url", "https://udc.crate.io/", Function.identity(), DataTypes.STRING, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<TimeValue> UDC_INITIAL_DELAY_SETTING = Setting.positiveTimeSetting("udc.initial_delay", new TimeValue(10L, TimeUnit.MINUTES), Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<TimeValue> UDC_INTERVAL_SETTING = Setting.positiveTimeSetting("udc.interval", new TimeValue(24L, TimeUnit.HOURS), Setting.Property.NodeScope, Setting.Property.Exposed);
    private final Timer timer;
    private final ClusterService clusterService;
    private final ExtendedNodeInfo extendedNodeInfo;
    private final Settings settings;

    @Inject
    public UDCService(Settings settings, ExtendedNodeInfo extendedNodeInfo, ClusterService clusterService) {
        this.settings = settings;
        this.extendedNodeInfo = extendedNodeInfo;
        this.clusterService = clusterService;
        this.timer = new Timer("crate-udc");
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        String url = UDC_URL_SETTING.get(this.settings);
        TimeValue initialDelay = UDC_INITIAL_DELAY_SETTING.get(this.settings);
        TimeValue interval = UDC_INTERVAL_SETTING.get(this.settings);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting with delay {} and period {}.", (Object)initialDelay.seconds(), (Object)interval.seconds());
        }
        PingTask pingTask = new PingTask(this.clusterService, this.extendedNodeInfo, url);
        this.timer.scheduleAtFixedRate((TimerTask)pingTask, initialDelay.millis(), interval.millis());
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        this.timer.cancel();
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.timer.cancel();
    }
}

