/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Singleton
public class TransportCreatePartitionsAction
extends TransportMasterNodeAction<CreatePartitionsRequest, AcknowledgedResponse> {
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final ActiveShardsObserver activeShardsObserver;
    private final ShardLimitValidator shardLimitValidator;
    private final MetadataUpgrader metadataUpgrader;
    private final ClusterStateTaskExecutor<CreatePartitionsRequest> executor = (currentState, tasks) -> {
        ClusterStateTaskExecutor.ClusterTasksResult.Builder<CreatePartitionsRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
        for (CreatePartitionsRequest request : tasks) {
            try {
                currentState = this.executeCreateIndices(currentState, request);
                builder.success(request);
            }
            catch (Exception e) {
                builder.failure(request, e);
            }
        }
        return builder.build(currentState);
    };
    private final AtomicBoolean upgraded;

    @Inject
    public TransportCreatePartitionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService, AllocationService allocationService, ShardLimitValidator shardLimitValidator, MetadataUpgrader metadataUpgrader) {
        super("indices:admin/bulk_create", transportService, clusterService, threadPool, CreatePartitionsRequest::new);
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
        this.shardLimitValidator = shardLimitValidator;
        this.metadataUpgrader = metadataUpgrader;
        this.upgraded = new AtomicBoolean(false);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CreatePartitionsRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws ElasticsearchException {
        this.createIndices(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                List<String> indexNames = request.indexNames();
                this.activeShardsObserver.waitForActiveShards((String[])indexNames.toArray(String[]::new), ActiveShardCount.DEFAULT, request.ackTimeout(), shardsAcked -> {
                    if (!shardsAcked.booleanValue() && this.logger.isInfoEnabled()) {
                        RelationName relationName = request.relationName();
                        String partitionTemplateName = PartitionName.templateName(relationName.schema(), relationName.name());
                        IndexTemplateMetadata templateMetadata = state.metadata().templates().get(partitionTemplateName);
                        this.logger.info("[{}] Table partitions created, but the operation timed out while waiting for enough shards to be started. Timeout={}, wait_for_active_shards={}. Consider decreasing the 'number_of_shards' table setting (currently: {}) or adding nodes to the cluster.", (Object)relationName, (Object)request.timeout(), (Object)IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.get(templateMetadata.settings()), (Object)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(templateMetadata.settings()));
                    }
                    listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
                }, listener::onFailure);
            } else {
                this.logger.warn("[{}] Table partitions created, but publishing new cluster state timed out. Timeout={}", (Object)request.relationName(), (Object)request.timeout());
                listener.onResponse(new AcknowledgedResponse(false));
            }
        }, listener::onFailure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState executeCreateIndices(ClusterState currentState, CreatePartitionsRequest request) throws Exception {
        List<String> indicesToCreate;
        Index testIndex;
        String removalReason;
        block14: {
            removalReason = null;
            testIndex = null;
            indicesToCreate = this.getValidatedIndicesToCreate(currentState, request);
            if (!indicesToCreate.isEmpty()) break block14;
            ClusterState clusterState = currentState;
            if (testIndex != null) {
                this.indicesService.removeIndex(testIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason != null ? removalReason : "failed to create index");
            }
            return clusterState;
        }
        try {
            IndexTemplateMetadata template;
            String firstIndex = indicesToCreate.get(0);
            String templateName = PartitionName.templateName(firstIndex);
            Metadata metadata = currentState.metadata();
            Metadata.Builder newMetadataBuilder = Metadata.builder(metadata);
            if (this.upgraded.compareAndSet(false, true)) {
                this.upgradeTemplates(metadata, newMetadataBuilder);
            }
            if ((template = newMetadataBuilder.getTemplate(templateName)) == null) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Cannot find a template for partitioned table's index %s", firstIndex));
            }
            Settings commonIndexSettings = this.createCommonIndexSettings(currentState, template);
            int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(commonIndexSettings);
            int numberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(commonIndexSettings);
            int numShardsToCreate = numberOfShards * (1 + numberOfReplicas) * indicesToCreate.size();
            this.shardLimitValidator.checkShardLimit(numShardsToCreate, currentState).ifPresent(err -> {
                ValidationException e = new ValidationException();
                e.addValidationError((String)err);
                throw e;
            });
            int numTargetShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(commonIndexSettings);
            Version indexVersionCreated = commonIndexSettings.getAsVersion("index.version.created", null);
            int routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(commonIndexSettings) ? numTargetShards : MetadataCreateIndexService.calculateNumRoutingShards(numTargetShards, indexVersionCreated);
            IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(firstIndex).setRoutingNumShards(routingNumShards);
            IndexMetadata tmpImd = tmpImdBuilder.settings(Settings.builder().put(commonIndexSettings).put("index.uuid", UUIDs.randomBase64UUID())).build();
            ActiveShardCount waitForActiveShards = tmpImd.getWaitForActiveShards();
            if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                throw new IllegalArgumentException("invalid wait_for_active_shards[" + String.valueOf(waitForActiveShards) + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
            }
            IndicesClusterStateService.AllocatedIndex indexService = this.indicesService.createIndex(tmpImd, Collections.emptyList(), false);
            testIndex = ((AbstractIndexComponent)((Object)indexService)).index();
            MappingMetadata mappingMetadata = new MappingMetadata(template.mapping());
            for (String index : indicesToCreate) {
                IndexMetadata indexMetadata;
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(index).setRoutingNumShards(routingNumShards).settings(Settings.builder().put(commonIndexSettings).put("index.uuid", UUIDs.randomBase64UUID()));
                indexMetadataBuilder.putMapping(mappingMetadata);
                for (ObjectCursor aliasCursor : template.aliases().values()) {
                    indexMetadataBuilder.putAlias((AliasMetadata)aliasCursor.value);
                }
                indexMetadataBuilder.state(IndexMetadata.State.OPEN);
                try {
                    indexMetadata = indexMetadataBuilder.build();
                }
                catch (Exception e) {
                    removalReason = "failed to build index metadata";
                    throw e;
                }
                this.logger.info("[{}] creating index, cause [bulk], template {}, shards [{}]/[{}]", (Object)index, (Object)templateName, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas());
                ((IndexService)indexService).getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
                newMetadataBuilder.put(indexMetadata, false);
            }
            Metadata newMetadata = newMetadataBuilder.build();
            ClusterState updatedState = ClusterState.builder(currentState).metadata(newMetadata).build();
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable());
            for (String index : indicesToCreate) {
                routingTableBuilder.addAsNew(updatedState.metadata().index(index));
            }
            ClusterState clusterState = this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "bulk-index-creation");
            if (testIndex != null) {
                this.indicesService.removeIndex(testIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason != null ? removalReason : "failed to create index");
            }
            return clusterState;
        }
        catch (Throwable throwable) {
            if (testIndex != null) {
                this.indicesService.removeIndex(testIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason != null ? removalReason : "failed to create index");
            }
            throw throwable;
        }
    }

    public void upgradeTemplates(Metadata metadata, Metadata.Builder newMetadataBuilder) {
        GatewayMetaState.applyPluginUpgraders(metadata.templates(), this.metadataUpgrader.indexTemplateMetadataUpgraders, newMetadataBuilder::removeTemplate, (string, indexTemplateMetadata) -> newMetadataBuilder.put((IndexTemplateMetadata)indexTemplateMetadata));
    }

    @VisibleForTesting
    void createIndices(final CreatePartitionsRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("bulk-create-indices", request, ClusterStateTaskConfig.build(Priority.URGENT, request.masterNodeTimeout()), this.executor, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, (AckedRequest)request, listener){
            final /* synthetic */ TransportCreatePartitionsAction this$0;
            {
                this.this$0 = this$0;
                super(request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return this.this$0.executeCreateIndices(currentState, request);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }
        });
    }

    private List<String> getValidatedIndicesToCreate(ClusterState state, CreatePartitionsRequest request) {
        ArrayList<String> indicesToCreate = new ArrayList<String>(request.partitionValuesList().size());
        for (List<String> partitionValues : request.partitionValuesList()) {
            String index = new PartitionName(request.relationName(), partitionValues).asIndexName();
            if (state.metadata().hasIndex(index) || state.routingTable().hasIndex(index)) continue;
            IndexName.validate(index);
            indicesToCreate.add(index);
        }
        return indicesToCreate;
    }

    private Settings createCommonIndexSettings(ClusterState currentState, @Nullable IndexTemplateMetadata template) {
        Settings.Builder indexSettingsBuilder = Settings.builder();
        if (template != null) {
            indexSettingsBuilder.put(template.settings());
        }
        Version minVersion = currentState.nodes().getSmallestNonClientNodeVersion();
        indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), minVersion);
        MetadataCreateIndexService.validateSoftDeletesSetting(indexSettingsBuilder.build());
        if (indexSettingsBuilder.get("index.creation_date") == null) {
            indexSettingsBuilder.put("index.creation_date", new DateTime(DateTimeZone.UTC).getMillis());
        }
        return indexSettingsBuilder.build();
    }

    @Override
    protected ClusterBlockException checkBlock(CreatePartitionsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, (String[])request.indexNames().toArray(String[]::new));
    }
}

