/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.retention;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.retention.SyncRetentionLeasesRequest;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.transport.TransportService;

public class TransportSyncRetentionLeasesAction
extends TransportBroadcastByNodeAction<SyncRetentionLeasesRequest, BroadcastResponse, ReplicationResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportSyncRetentionLeasesAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
        super("indices:admin/sync_leases", clusterService, transportService, SyncRetentionLeasesRequest::new, "force_merge", true);
        this.indicesService = indicesService;
    }

    @Override
    protected ReplicationResponse readShardResult(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected BroadcastResponse newResponse(SyncRetentionLeasesRequest request, int totalShards, int successfulShards, int failedShards, List<ReplicationResponse> replicationResponses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new BroadcastResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected SyncRetentionLeasesRequest readRequestFrom(StreamInput in) throws IOException {
        return new SyncRetentionLeasesRequest(in);
    }

    @Override
    protected void shardOperation(SyncRetentionLeasesRequest request, ShardRouting shardRouting, ActionListener<ReplicationResponse> listener) throws IOException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        indexShard.runUnderPrimaryPermit(() -> indexShard.syncRetentionLeases(true, listener), e -> {
            this.logger.warn("Retention lease sync failed on shard " + String.valueOf(indexShard.shardId()), (Throwable)e);
            listener.onFailure((Exception)e);
        }, "same", "retention lease sync");
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, SyncRetentionLeasesRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allPrimaryShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, SyncRetentionLeasesRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, SyncRetentionLeasesRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

