/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportResizeAction
extends TransportMasterNodeAction<ResizeRequest, ResizeResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, Client client) {
        super("indices:admin/resize", transportService, clusterService, threadPool, ResizeRequest::new);
        this.createIndexService = createIndexService;
        this.client = client;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ResizeResponse read(StreamInput in) throws IOException {
        return new ResizeResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        if (request.partitionValues().isEmpty()) {
            return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.table().indexNameOrAlias());
        }
        PartitionName partitionName = new PartitionName(request.table(), request.partitionValues());
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, partitionName.asIndexName());
    }

    @Override
    protected void masterOperation(ResizeRequest request, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = request.partitionValues().isEmpty() ? request.table().indexNameOrAlias() : new PartitionName(request.table(), request.partitionValues()).asIndexName();
        String targetIndex = ".resized." + sourceIndex;
        this.client.admin().indices().stats(((IndicesStatsRequest)new IndicesStatsRequest().clear().indices(new String[]{sourceIndex})).docs(true)).whenComplete(ActionListener.delegateFailure(listener, (delegate, indicesStatsResponse) -> {
            CreateIndexClusterStateUpdateRequest updateRequest = TransportResizeAction.prepareCreateIndexRequest(request, state, i -> {
                IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                return shard == null ? null : shard.getPrimary().getDocs();
            }, sourceIndex, targetIndex);
            this.createIndexService.createIndex(updateRequest, delegate.map(response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
        }));
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest request, ClusterState state, IntFunction<DocsStats> perShardDocStats, String sourceIndexName, String targetIndexName) {
        IndexMetadata metadata = state.metadata().index(sourceIndexName);
        if (metadata == null) {
            throw new IndexNotFoundException(sourceIndexName);
        }
        int currentNumShards = metadata.getNumberOfShards();
        Settings targetSettings = Settings.builder().put("index.number_of_shards", request.newNumShards()).build();
        int targetNumShards = request.newNumShards();
        boolean shrink = currentNumShards > targetNumShards;
        for (int i = 0; i < targetNumShards; ++i) {
            if (shrink) {
                Set<ShardId> shardIds = IndexMetadata.selectShrinkShards(i, metadata, targetNumShards);
                long count = 0L;
                for (ShardId id : shardIds) {
                    DocsStats docsStats = perShardDocStats.apply(id.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + String.valueOf(shardIds));
                }
                continue;
            }
            Objects.requireNonNull(IndexMetadata.selectSplitShard(i, metadata, targetNumShards));
        }
        String indexNameOrAlias = request.table().indexNameOrAlias();
        Set<Object> aliases = sourceIndexName.equals(indexNameOrAlias) ? Set.of() : Set.of(new Alias(indexNameOrAlias));
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest("resize_table", targetIndexName).settings(targetSettings).aliases(aliases).ackTimeout(request.ackTimeout())).masterNodeTimeout(request.masterNodeTimeout())).waitForActiveShards(ActiveShardCount.ONE).recoverFrom(metadata.getIndex()).resizeType(shrink ? ResizeType.SHRINK : ResizeType.SPLIT).copySettings(true);
    }
}

