/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class CommonStatsFlags
implements Writeable,
Cloneable {
    public static final CommonStatsFlags ALL = new CommonStatsFlags(new Flag[0]).all();
    public static final CommonStatsFlags NONE = new CommonStatsFlags(new Flag[0]).clear();
    private EnumSet<Flag> flags = EnumSet.allOf(Flag.class);
    private String[] groups = null;
    private String[] fieldDataFields = null;
    private String[] completionDataFields = null;
    private boolean includeSegmentFileSizes = false;

    public CommonStatsFlags(Flag ... flags) {
        if (flags.length > 0) {
            this.clear();
            Collections.addAll(this.flags, flags);
        }
    }

    public CommonStatsFlags(StreamInput in) throws IOException {
        long longFlags = in.readLong();
        this.flags.clear();
        for (Flag flag : Flag.values()) {
            if ((longFlags & (long)(1 << flag.getIndex())) == 0L) continue;
            this.flags.add(flag);
        }
        if (in.getVersion().before(Version.V_4_3_0)) {
            in.readStringArray();
        }
        this.groups = in.readStringArray();
        this.fieldDataFields = in.readStringArray();
        this.completionDataFields = in.readStringArray();
        this.includeSegmentFileSizes = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long longFlags = 0L;
        for (Flag flag : this.flags) {
            longFlags |= (long)(1 << flag.getIndex());
        }
        out.writeLong(longFlags);
        if (out.getVersion().before(Version.V_4_3_0)) {
            out.writeStringArrayNullable(Strings.EMPTY_ARRAY);
        }
        out.writeStringArrayNullable(this.groups);
        out.writeStringArrayNullable(this.fieldDataFields);
        out.writeStringArrayNullable(this.completionDataFields);
        out.writeBoolean(this.includeSegmentFileSizes);
    }

    public CommonStatsFlags all() {
        this.flags = EnumSet.allOf(Flag.class);
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        this.includeSegmentFileSizes = false;
        return this;
    }

    public CommonStatsFlags clear() {
        this.flags = EnumSet.noneOf(Flag.class);
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        this.includeSegmentFileSizes = false;
        return this;
    }

    public boolean anySet() {
        return !this.flags.isEmpty();
    }

    public Flag[] getFlags() {
        return this.flags.toArray(new Flag[this.flags.size()]);
    }

    public CommonStatsFlags groups(String ... groups) {
        this.groups = groups;
        return this;
    }

    public String[] groups() {
        return this.groups;
    }

    public CommonStatsFlags fieldDataFields(String ... fieldDataFields) {
        this.fieldDataFields = fieldDataFields;
        return this;
    }

    public String[] fieldDataFields() {
        return this.fieldDataFields;
    }

    public CommonStatsFlags completionDataFields(String ... completionDataFields) {
        this.completionDataFields = completionDataFields;
        return this;
    }

    public String[] completionDataFields() {
        return this.completionDataFields;
    }

    public CommonStatsFlags includeSegmentFileSizes(boolean includeSegmentFileSizes) {
        this.includeSegmentFileSizes = includeSegmentFileSizes;
        return this;
    }

    public boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    public boolean isSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    boolean unSet(Flag flag) {
        return this.flags.remove((Object)flag);
    }

    void set(Flag flag) {
        this.flags.add(flag);
    }

    public CommonStatsFlags set(Flag flag, boolean add) {
        if (add) {
            this.set(flag);
        } else {
            this.unSet(flag);
        }
        return this;
    }

    public CommonStatsFlags clone() {
        try {
            CommonStatsFlags cloned = (CommonStatsFlags)super.clone();
            cloned.flags = this.flags.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum Flag {
        Store(0),
        Docs(9);

        private final int index;

        private Flag(int index) {
            this.index = index;
        }

        private int getIndex() {
            return this.index;
        }
    }
}

