/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportResponse;

public class BroadcastResponse
extends TransportResponse {
    public static final DefaultShardOperationFailedException[] EMPTY = new DefaultShardOperationFailedException[0];
    public static final BroadcastResponse EMPTY_RESPONSE = new BroadcastResponse(0, 0, 0, List.of());
    private final int totalShards;
    private final int successfulShards;
    private final int failedShards;
    private final DefaultShardOperationFailedException[] shardFailures;

    public BroadcastResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures == null ? EMPTY : shardFailures.toArray(new DefaultShardOperationFailedException[0]);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public RestStatus getStatus() {
        if (this.failedShards > 0) {
            return this.shardFailures[0].status();
        }
        return RestStatus.OK;
    }

    public DefaultShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    public BroadcastResponse(StreamInput in) throws IOException {
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size = in.readVInt();
        if (size > 0) {
            this.shardFailures = new DefaultShardOperationFailedException[size];
            for (int i = 0; i < size; ++i) {
                this.shardFailures[i] = new DefaultShardOperationFailedException(in);
            }
        } else {
            this.shardFailures = EMPTY;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.shardFailures.length);
        for (DefaultShardOperationFailedException exp : this.shardFailures) {
            exp.writeTo(out);
        }
    }
}

