/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class AcknowledgedRequest<Request extends MasterNodeRequest<Request>>
extends MasterNodeRequest<Request>
implements AckedRequest {
    public static final TimeValue DEFAULT_ACK_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    protected TimeValue timeout = DEFAULT_ACK_TIMEOUT;

    protected AcknowledgedRequest() {
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, (TimeValue)this.timeout, (String)(this.getClass().getSimpleName() + ".timeout"));
        return (Request)this;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public TimeValue ackTimeout() {
        return this.timeout;
    }

    public AcknowledgedRequest(StreamInput in) throws IOException {
        super(in);
        this.timeout = in.readTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeTimeValue(this.timeout);
    }
}

