/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public abstract class TransportWriteAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, ReplicaRequest, Response> {
    protected TransportWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, Writeable.Reader<Request> reader, Writeable.Reader<ReplicaRequest> replicaReader, String executor, boolean forceExecutionOnPrimary) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, reader, replicaReader, executor, true, forceExecutionOnPrimary);
    }

    protected static Translog.Location syncOperationResultOrThrow(Engine.Result operationResult, Translog.Location currentLocation) throws Exception {
        if (operationResult.getFailure() != null) {
            Exception failure = operationResult.getFailure();
            assert (failure instanceof MapperParsingException) : "expected mapper parsing failures. got " + String.valueOf(failure);
            throw failure;
        }
        Translog.Location location = TransportWriteAction.locationToSync(currentLocation, operationResult.getTranslogLocation());
        return location;
    }

    public static Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    @Override
    protected ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy() {
        return new WriteActionReplicasProxy();
    }

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    class WriteActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        WriteActionReplicasProxy() {
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            if (!TransportActions.isShardNotAvailableException(exception)) {
                TransportWriteAction.this.logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)replica.shardId(), (Object)message), (Throwable)exception);
            }
            TransportWriteAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, true, message, exception, listener);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportWriteAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }

    static final class AsyncAfterWriteAction {
        private final Translog.Location location;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final IndexShard indexShard;

        AsyncAfterWriteAction(IndexShard indexShard, @Nullable Translog.Location location, RespondingWriteResult respond) {
            this.indexShard = indexShard;
            this.respond = respond;
            this.location = location;
            this.sync = indexShard.getTranslogDurability() == Translog.Durability.REQUEST && location != null;
            if (this.sync) {
                this.pendingOps.incrementAndGet();
            }
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOpts was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        void run() {
            this.indexShard.afterWriteOperation();
            this.maybeFinish();
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.sync(this.location, ex -> {
                    this.syncFailure.set((Exception)ex);
                    this.maybeFinish();
                });
            }
        }
    }

    static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    protected static class WriteReplicaResult
    extends TransportReplicationAction.ReplicaResult
    implements RespondingWriteResult {
        private final Translog.Location location;
        private final IndexShard replica;

        public WriteReplicaResult(@Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard replica) {
            super(operationFailure);
            this.location = location;
            this.replica = replica;
        }

        @Override
        public void runPostReplicaActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.replica, this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }).run();
            }
        }

        @Override
        public void onSuccess(boolean forcedRefresh) {
        }

        @Override
        public void onFailure(Exception ex) {
        }
    }

    protected static class WritePrimaryResult<ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
    extends TransportReplicationAction.PrimaryResult<ReplicaRequest, Response> {
        public final Translog.Location location;
        public final IndexShard primary;

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard primary) {
            super(request, finalResponse, operationFailure);
            this.location = location;
            this.primary = primary;
            assert (location == null || operationFailure == null) : "expected either failure to be null or translog location to be null, but found: [" + String.valueOf(location) + "] translog location and [" + String.valueOf(operationFailure) + "] failure";
        }

        @Override
        public void runPostReplicationActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.primary, this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }).run();
            }
        }
    }
}

