/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectContainer;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public class InternalClusterInfoService
implements ClusterInfoService,
ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(InternalClusterInfoService.class);
    private static final String REFRESH_EXECUTOR = "management";
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING = Setting.timeSetting("cluster.info.update.interval", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<TimeValue> INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.info.update.timeout", TimeValue.timeValueSeconds((long)15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile TimeValue updateFrequency;
    volatile ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsages;
    volatile ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsages;
    private volatile IndicesStatsSummary indicesStatsSummary;
    private final AtomicReference<RefreshAndRescheduleRunnable> refreshAndRescheduleRunnable = new AtomicReference();
    private volatile boolean enabled;
    private volatile TimeValue fetchTimeout;
    private ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Client client;
    private final List<Consumer<ClusterInfo>> listeners = new CopyOnWriteArrayList<Consumer<ClusterInfo>>();

    public InternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
        this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
        this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.updateFrequency = INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING.get(settings);
        this.fetchTimeout = INTERNAL_CLUSTER_INFO_TIMEOUT_SETTING.get(settings);
        this.enabled = DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL_SETTING, this::setUpdateFrequency);
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setUpdateFrequency(TimeValue updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster() && this.refreshAndRescheduleRunnable.get() == null) {
            LOGGER.trace("elected as master, scheduling cluster info update tasks");
            this.executeRefresh(event.state(), "became master");
            RefreshAndRescheduleRunnable newRunnable = new RefreshAndRescheduleRunnable();
            this.refreshAndRescheduleRunnable.set(newRunnable);
            this.threadPool.scheduleUnlessShuttingDown(this.updateFrequency, REFRESH_EXECUTOR, newRunnable);
        } else if (!event.localNodeMaster()) {
            this.refreshAndRescheduleRunnable.set(null);
            return;
        }
        if (!this.enabled) {
            return;
        }
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.isDataNode()) continue;
            this.executeRefresh(event.state(), "data node added");
            break;
        }
        for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
            if (!removedNode.isDataNode()) continue;
            LOGGER.trace("Removing node from cluster info: {}", (Object)removedNode.getId());
            if (this.leastAvailableSpaceUsages.containsKey(removedNode.getId())) {
                ImmutableOpenMap.Builder<String, DiskUsage> newMaxUsages = ImmutableOpenMap.builder(this.leastAvailableSpaceUsages);
                newMaxUsages.remove(removedNode.getId());
                this.leastAvailableSpaceUsages = newMaxUsages.build();
            }
            if (!this.mostAvailableSpaceUsages.containsKey(removedNode.getId())) continue;
            ImmutableOpenMap.Builder<String, DiskUsage> newMinUsages = ImmutableOpenMap.builder(this.mostAvailableSpaceUsages);
            newMinUsages.remove(removedNode.getId());
            this.mostAvailableSpaceUsages = newMinUsages.build();
        }
    }

    private void executeRefresh(ClusterState clusterState, String reason) {
        if (clusterState.nodes().getDataNodes().size() > 1) {
            LOGGER.trace("refreshing cluster info in background [{}]", (Object)reason);
            this.threadPool.executor(REFRESH_EXECUTOR).execute(new RefreshRunnable(reason));
        }
    }

    @Override
    public ClusterInfo getClusterInfo() {
        IndicesStatsSummary indicesStatsSummary = this.indicesStatsSummary;
        return new ClusterInfo(this.leastAvailableSpaceUsages, this.mostAvailableSpaceUsages, indicesStatsSummary.shardSizes, indicesStatsSummary.shardRoutingToDataPath, indicesStatsSummary.reservedSpace);
    }

    protected CompletableFuture<NodesStatsResponse> updateNodeStats() {
        ObjectContainer<DiscoveryNode> allDataNodes = this.clusterService.state().nodes().getDataNodes().values();
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest((DiscoveryNode[])allDataNodes.toArray(DiscoveryNode.class));
        nodesStatsRequest.timeout(this.fetchTimeout);
        return this.client.admin().cluster().nodesStats(nodesStatsRequest);
    }

    private CompletableFuture<IndicesStatsResponse> updateIndicesStats() {
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.clear();
        indicesStatsRequest.store(true);
        indicesStatsRequest.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN_CLOSED);
        return this.client.admin().indices().stats(indicesStatsRequest);
    }

    List<NodeStats> adjustNodesStats(List<NodeStats> nodeStats) {
        return nodeStats;
    }

    public final ClusterInfo refresh() {
        Throwable e;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("refreshing cluster info");
        }
        CompletableFuture<NodesStatsResponse> nodesStatsResponse = this.updateNodeStats();
        CompletableFuture<IndicesStatsResponse> indicesStatsResponse = this.updateIndicesStats();
        try {
            NodesStatsResponse nodesStats = nodesStatsResponse.get(this.fetchTimeout.millis(), TimeUnit.MILLISECONDS);
            ImmutableOpenMap.Builder<String, DiskUsage> leastAvailableUsagesBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<String, DiskUsage> mostAvailableUsagesBuilder = ImmutableOpenMap.builder();
            InternalClusterInfoService.fillDiskUsagePerNode(LOGGER, this.adjustNodesStats(nodesStats.getNodes()), leastAvailableUsagesBuilder, mostAvailableUsagesBuilder);
            this.leastAvailableSpaceUsages = leastAvailableUsagesBuilder.build();
            this.mostAvailableSpaceUsages = mostAvailableUsagesBuilder.build();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Failed to update node information for ClusterInfoUpdateJob within {} timeout", (Object)this.fetchTimeout);
        }
        catch (Throwable err) {
            e = SQLExceptions.unwrap(err);
            if (e instanceof ReceiveTimeoutTransportException) {
                LOGGER.error("NodeStatsAction timed out for ClusterInfoUpdateJob", e);
            }
            if (e instanceof ClusterBlockException) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", e);
                }
            } else {
                LOGGER.warn("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", e);
            }
            this.leastAvailableSpaceUsages = ImmutableOpenMap.of();
            this.mostAvailableSpaceUsages = ImmutableOpenMap.of();
        }
        try {
            IndicesStatsResponse indicesStats = indicesStatsResponse.get(this.fetchTimeout.millis(), TimeUnit.MILLISECONDS);
            ShardStats[] stats = indicesStats.getShards();
            ImmutableOpenMap.Builder<String, Long> shardSizeByIdentifierBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<ShardRouting, String> dataPathByShardRoutingBuilder = ImmutableOpenMap.builder();
            HashMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder> reservedSpaceBuilders = new HashMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder>();
            InternalClusterInfoService.buildShardLevelInfo(LOGGER, stats, shardSizeByIdentifierBuilder, dataPathByShardRoutingBuilder, reservedSpaceBuilders);
            ImmutableOpenMap.Builder rsrvdSpace = ImmutableOpenMap.builder();
            reservedSpaceBuilders.forEach((nodeAndPath, builder) -> rsrvdSpace.put(nodeAndPath, builder.build()));
            this.indicesStatsSummary = new IndicesStatsSummary(shardSizeByIdentifierBuilder.build(), dataPathByShardRoutingBuilder.build(), rsrvdSpace.build());
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Failed to update shard information for ClusterInfoUpdateJob within {} timeout", (Object)this.fetchTimeout);
        }
        catch (Throwable err) {
            e = SQLExceptions.unwrap(err);
            if (e instanceof ReceiveTimeoutTransportException) {
                LOGGER.error("IndicesStatsAction timed out for ClusterInfoUpdateJob", e);
            }
            if (e instanceof ClusterBlockException) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", e);
                }
            } else {
                LOGGER.warn("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", e);
            }
            this.indicesStatsSummary = IndicesStatsSummary.EMPTY;
        }
        ClusterInfo clusterInfo = this.getClusterInfo();
        boolean anyListeners = false;
        for (Consumer<ClusterInfo> listener : this.listeners) {
            anyListeners = true;
            try {
                LOGGER.trace("notifying [{}] of new cluster info", listener);
                listener.accept(clusterInfo);
            }
            catch (Exception e4) {
                LOGGER.info((Message)new ParameterizedMessage("failed to notify [{}] of new cluster info", listener), (Throwable)e4);
            }
        }
        assert (anyListeners) : "expected to notify at least one listener";
        return clusterInfo;
    }

    @Override
    public void addListener(Consumer<ClusterInfo> clusterInfoConsumer) {
        this.listeners.add(clusterInfoConsumer);
    }

    static void buildShardLevelInfo(Logger logger, ShardStats[] stats, ImmutableOpenMap.Builder<String, Long> shardSizes, ImmutableOpenMap.Builder<ShardRouting, String> newShardRoutingToDataPath, Map<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace.Builder> reservedSpaceByShard) {
        for (ShardStats s : stats) {
            ShardRouting shardRouting = s.getShardRouting();
            newShardRoutingToDataPath.put(shardRouting, s.getDataPath());
            StoreStats storeStats = s.getStats().getStore();
            if (storeStats == null) continue;
            long size = storeStats.sizeInBytes();
            long reserved = storeStats.getReservedSize().getBytes();
            String shardIdentifier = ClusterInfo.shardIdentifierFromRouting(shardRouting);
            logger.trace("shard: {} size: {} reserved: {}", (Object)shardIdentifier, (Object)size, (Object)reserved);
            shardSizes.put(shardIdentifier, size);
            if (reserved == -1L) continue;
            ClusterInfo.ReservedSpace.Builder reservedSpaceBuilder = reservedSpaceByShard.computeIfAbsent(new ClusterInfo.NodeAndPath(shardRouting.currentNodeId(), s.getDataPath()), t -> new ClusterInfo.ReservedSpace.Builder());
            reservedSpaceBuilder.add(shardRouting.shardId(), reserved);
        }
    }

    static void fillDiskUsagePerNode(Logger logger, List<NodeStats> nodeStatsArray, ImmutableOpenMap.Builder<String, DiskUsage> newLeastAvaiableUsages, ImmutableOpenMap.Builder<String, DiskUsage> newMostAvaiableUsages) {
        boolean traceEnabled = logger.isTraceEnabled();
        for (NodeStats nodeStats : nodeStatsArray) {
            if (nodeStats.getFs() == null) {
                logger.warn("Unable to retrieve node FS stats for {}", (Object)nodeStats.getNode().getName());
                continue;
            }
            FsInfo.Path leastAvailablePath = null;
            FsInfo.Path mostAvailablePath = null;
            for (FsInfo.Path info : nodeStats.getFs()) {
                if (leastAvailablePath == null) {
                    assert (mostAvailablePath == null);
                    mostAvailablePath = leastAvailablePath = info;
                    continue;
                }
                if (leastAvailablePath.getAvailable().getBytes() > info.getAvailable().getBytes()) {
                    leastAvailablePath = info;
                    continue;
                }
                if (mostAvailablePath.getAvailable().getBytes() >= info.getAvailable().getBytes()) continue;
                mostAvailablePath = info;
            }
            String nodeId = nodeStats.getNode().getId();
            String nodeName = nodeStats.getNode().getName();
            if (logger.isTraceEnabled()) {
                logger.trace("node: [{}], most available: total disk: {}, available disk: {} / least available: total disk: {}, available disk: {}", (Object)nodeId, (Object)mostAvailablePath.getTotal(), (Object)mostAvailablePath.getAvailable(), (Object)leastAvailablePath.getTotal(), (Object)leastAvailablePath.getAvailable());
            }
            if (leastAvailablePath.getTotal().getBytes() < 0L) {
                if (traceEnabled) {
                    logger.trace("node: [{}] least available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)leastAvailablePath.getTotal().getBytes());
                }
            } else {
                newLeastAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, leastAvailablePath.getPath(), leastAvailablePath.getTotal().getBytes(), leastAvailablePath.getAvailable().getBytes()));
            }
            if (mostAvailablePath.getTotal().getBytes() < 0L) {
                if (!traceEnabled) continue;
                logger.trace("node: [{}] most available path has less than 0 total bytes of disk [{}], skipping", (Object)nodeId, (Object)mostAvailablePath.getTotal().getBytes());
                continue;
            }
            newMostAvaiableUsages.put(nodeId, new DiskUsage(nodeId, nodeName, mostAvailablePath.getPath(), mostAvailablePath.getTotal().getBytes(), mostAvailablePath.getAvailable().getBytes()));
        }
    }

    private static class IndicesStatsSummary {
        static final IndicesStatsSummary EMPTY = new IndicesStatsSummary(ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of());
        final ImmutableOpenMap<String, Long> shardSizes;
        final ImmutableOpenMap<ShardRouting, String> shardRoutingToDataPath;
        final ImmutableOpenMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace> reservedSpace;

        IndicesStatsSummary(ImmutableOpenMap<String, Long> shardSizes, ImmutableOpenMap<ShardRouting, String> shardRoutingToDataPath, ImmutableOpenMap<ClusterInfo.NodeAndPath, ClusterInfo.ReservedSpace> reservedSpace) {
            this.shardSizes = shardSizes;
            this.shardRoutingToDataPath = shardRoutingToDataPath;
            this.reservedSpace = reservedSpace;
        }
    }

    private class RefreshAndRescheduleRunnable
    extends RefreshRunnable {
        RefreshAndRescheduleRunnable() {
            super("scheduled");
        }

        @Override
        protected void doRun() {
            if (this == InternalClusterInfoService.this.refreshAndRescheduleRunnable.get()) {
                super.doRun();
            } else {
                LOGGER.trace("master changed, scheduled refresh job is stale");
            }
        }

        @Override
        public void onAfter() {
            if (this == InternalClusterInfoService.this.refreshAndRescheduleRunnable.get()) {
                LOGGER.trace("scheduling next cluster info refresh in [{}]", (Object)InternalClusterInfoService.this.updateFrequency);
                InternalClusterInfoService.this.threadPool.scheduleUnlessShuttingDown(InternalClusterInfoService.this.updateFrequency, InternalClusterInfoService.REFRESH_EXECUTOR, this);
            }
        }
    }

    private class RefreshRunnable
    extends AbstractRunnable {
        private final String reason;

        RefreshRunnable(String reason) {
            this.reason = reason;
        }

        @Override
        protected void doRun() {
            if (InternalClusterInfoService.this.enabled) {
                LOGGER.trace("refreshing cluster info [{}]", (Object)this.reason);
                InternalClusterInfoService.this.refresh();
            } else {
                LOGGER.trace("skipping cluster info refresh [{}] since it is disabled", (Object)this.reason);
            }
        }

        @Override
        public void onFailure(Exception e) {
            LOGGER.warn((Message)new ParameterizedMessage("refreshing cluster info failed [{}]", (Object)this.reason), (Throwable)e);
        }

        @Override
        public void onRejection(Exception e) {
            boolean shutDown = e instanceof EsRejectedExecutionException && ((EsRejectedExecutionException)e).isExecutorShutdown();
            LOGGER.log(shutDown ? Level.DEBUG : Level.WARN, "refreshing cluster info rejected [{}]", (Object)this.reason, (Object)e);
        }
    }
}

