/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.NodeHealthCheckFailureException;
import org.elasticsearch.cluster.coordination.PreVoteRequest;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class PreVoteCollector {
    private static final Logger LOGGER = LogManager.getLogger(PreVoteCollector.class);
    public static final String REQUEST_PRE_VOTE_ACTION_NAME = "internal:cluster/request_pre_vote";
    private final TransportService transportService;
    private final Runnable startElection;
    private final LongConsumer updateMaxTermSeen;
    private final ElectionStrategy electionStrategy;
    private NodeHealthService nodeHealthService;
    private volatile State state;

    PreVoteCollector(TransportService transportService, Runnable startElection, LongConsumer updateMaxTermSeen, ElectionStrategy electionStrategy, NodeHealthService nodeHealthService) {
        this.transportService = transportService;
        this.startElection = startElection;
        this.updateMaxTermSeen = updateMaxTermSeen;
        this.electionStrategy = electionStrategy;
        this.nodeHealthService = nodeHealthService;
        transportService.registerRequestHandler(REQUEST_PRE_VOTE_ACTION_NAME, "generic", false, false, PreVoteRequest::new, (request, channel) -> channel.sendResponse(this.handlePreVoteRequest((PreVoteRequest)request)));
    }

    public Releasable start(ClusterState clusterState, Iterable<DiscoveryNode> broadcastNodes) {
        PreVotingRound preVotingRound = new PreVotingRound(clusterState, this.state.preVoteResponse().getCurrentTerm());
        preVotingRound.start(broadcastNodes);
        return preVotingRound;
    }

    PreVoteResponse getPreVoteResponse() {
        return this.state.preVoteResponse();
    }

    @Nullable
    DiscoveryNode getLeader() {
        return this.state.leader();
    }

    public void update(PreVoteResponse preVoteResponse, @Nullable DiscoveryNode leader) {
        LOGGER.trace("updating with preVoteResponse={}, leader={}", (Object)preVoteResponse, (Object)leader);
        this.state = new State(leader, preVoteResponse);
    }

    private PreVoteResponse handlePreVoteRequest(PreVoteRequest request) {
        this.updateMaxTermSeen.accept(request.getCurrentTerm());
        State state = this.state;
        assert (state != null) : "received pre-vote request before fully initialised";
        DiscoveryNode leader = state.leader();
        PreVoteResponse response = state.preVoteResponse();
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
            String message = "rejecting " + String.valueOf(request) + " on unhealthy node: [" + statusInfo.getInfo() + "]";
            LOGGER.debug(message);
            throw new NodeHealthCheckFailureException(message, new Object[0]);
        }
        if (leader == null) {
            return response;
        }
        if (leader.equals(request.getSourceNode())) {
            return response;
        }
        throw new CoordinationStateRejectedException("rejecting " + String.valueOf(request) + " as there is already a leader", new Object[0]);
    }

    public String toString() {
        return "PreVoteCollector{state=" + String.valueOf(this.state) + "}";
    }

    private class PreVotingRound
    implements Releasable {
        private final Map<DiscoveryNode, PreVoteResponse> preVotesReceived = new ConcurrentHashMap<DiscoveryNode, PreVoteResponse>();
        private final AtomicBoolean electionStarted = new AtomicBoolean();
        private final PreVoteRequest preVoteRequest;
        private final ClusterState clusterState;
        private final AtomicBoolean isClosed = new AtomicBoolean();

        PreVotingRound(ClusterState clusterState, long currentTerm) {
            this.clusterState = clusterState;
            this.preVoteRequest = new PreVoteRequest(PreVoteCollector.this.transportService.getLocalNode(), currentTerm);
        }

        void start(Iterable<DiscoveryNode> broadcastNodes) {
            LOGGER.debug("{} requesting pre-votes from {}", (Object)this, broadcastNodes);
            broadcastNodes.forEach(n -> PreVoteCollector.this.transportService.sendRequest((DiscoveryNode)n, PreVoteCollector.REQUEST_PRE_VOTE_ACTION_NAME, this.preVoteRequest, new TransportResponseHandler<PreVoteResponse>(){
                final /* synthetic */ PreVotingRound this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public PreVoteResponse read(StreamInput in) throws IOException {
                    return new PreVoteResponse(in);
                }

                @Override
                public void handleResponse(PreVoteResponse response) {
                    this.this$1.handlePreVoteResponse(response, n);
                }

                @Override
                public void handleException(TransportException exp) {
                    LOGGER.debug((Message)new ParameterizedMessage("{} failed", (Object)this), (Throwable)exp);
                }

                @Override
                public String executor() {
                    return "generic";
                }

                public String toString() {
                    return "TransportResponseHandler{" + String.valueOf(this.this$1.PreVoteCollector.this) + ", node=" + String.valueOf(n) + "}";
                }
            }));
        }

        private void handlePreVoteResponse(PreVoteResponse response, DiscoveryNode sender) {
            if (this.isClosed.get()) {
                LOGGER.debug("{} is closed, ignoring {} from {}", (Object)this, (Object)response, (Object)sender);
                return;
            }
            PreVoteCollector.this.updateMaxTermSeen.accept(response.getCurrentTerm());
            if (response.getLastAcceptedTerm() > this.clusterState.term() || response.getLastAcceptedTerm() == this.clusterState.term() && response.getLastAcceptedVersion() > this.clusterState.version()) {
                LOGGER.debug("{} ignoring {} from {} as it is fresher", (Object)this, (Object)response, (Object)sender);
                return;
            }
            this.preVotesReceived.put(sender, response);
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            DiscoveryNode localNode = this.clusterState.nodes().getLocalNode();
            PreVoteResponse localPreVoteResponse = PreVoteCollector.this.getPreVoteResponse();
            this.preVotesReceived.forEach((node, preVoteResponse) -> voteCollection.addJoinVote(new Join((DiscoveryNode)node, localNode, preVoteResponse.getCurrentTerm(), preVoteResponse.getLastAcceptedTerm(), preVoteResponse.getLastAcceptedVersion())));
            if (!PreVoteCollector.this.electionStrategy.isElectionQuorum(this.clusterState.nodes().getLocalNode(), localPreVoteResponse.getCurrentTerm(), localPreVoteResponse.getLastAcceptedTerm(), localPreVoteResponse.getLastAcceptedVersion(), this.clusterState.getLastCommittedConfiguration(), this.clusterState.getLastAcceptedConfiguration(), voteCollection)) {
                LOGGER.debug("{} added {} from {}, no quorum yet", (Object)this, (Object)response, (Object)sender);
                return;
            }
            if (!this.electionStarted.compareAndSet(false, true)) {
                LOGGER.debug("{} added {} from {} but election has already started", (Object)this, (Object)response, (Object)sender);
                return;
            }
            LOGGER.debug("{} added {} from {}, starting election", (Object)this, (Object)response, (Object)sender);
            PreVoteCollector.this.startElection.run();
        }

        public String toString() {
            return "PreVotingRound{preVotesReceived=" + String.valueOf(this.preVotesReceived) + ", electionStarted=" + String.valueOf(this.electionStarted) + ", preVoteRequest=" + String.valueOf(this.preVoteRequest) + ", isClosed=" + String.valueOf(this.isClosed) + "}";
        }

        @Override
        public void close() {
            boolean isNotAlreadyClosed = this.isClosed.compareAndSet(false, true);
            assert (isNotAlreadyClosed);
        }
    }

    private record State(@Nullable DiscoveryNode leader, PreVoteResponse preVoteResponse) {
    }
}

