/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;

public class AliasMetadata
extends AbstractDiffable<AliasMetadata> {
    private final String alias;

    public AliasMetadata(String alias) {
        this.alias = alias;
    }

    public String alias() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasMetadata that = (AliasMetadata)o;
        return Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return this.alias != null ? this.alias.hashCode() : 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias());
        if (out.getVersion().before(Version.V_5_3_0)) {
            out.writeBoolean(false);
            out.writeBoolean(false);
            out.writeBoolean(false);
            out.writeOptionalBoolean(null);
        }
    }

    public AliasMetadata(StreamInput in) throws IOException {
        this.alias = in.readString();
        if (in.getVersion().before(Version.V_5_3_0)) {
            if (in.readBoolean()) {
                CompressedXContent.readCompressedString(in);
            }
            if (in.readBoolean()) {
                in.readString();
            }
            if (in.readBoolean()) {
                in.readString();
            }
            in.readOptionalBoolean();
        }
    }

    public static Diff<AliasMetadata> readDiffFrom(StreamInput in) throws IOException {
        return AliasMetadata.readDiffFrom(AliasMetadata::new, in);
    }

    public static class Builder {
        private final String alias;

        public Builder(String alias) {
            this.alias = alias;
        }

        public Builder(AliasMetadata aliasMetadata) {
            this(aliasMetadata.alias());
        }

        public String alias() {
            return this.alias;
        }

        public AliasMetadata build() {
            return new AliasMetadata(this.alias);
        }

        public static AliasMetadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return builder.build();
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("filter".equals(currentFieldName)) {
                        parser.mapOrdered();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                parser.skipChildren();
            }
            return builder.build();
        }
    }
}

