/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.metadata.IndexName;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.indices.InvalidAliasNameException;

public final class AliasValidator {
    private AliasValidator() {
    }

    public static void validateAlias(Alias alias, String index, Metadata metadata) {
        String aliasName = alias.name();
        AliasValidator.validateAliasName(aliasName);
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("index name is required");
        }
        IndexMetadata indexNamedSameAsAlias = ((Function<String, IndexMetadata>)metadata::index).apply(aliasName);
        if (indexNamedSameAsAlias != null) {
            throw new InvalidAliasNameException(indexNamedSameAsAlias.getIndex(), aliasName, "an index exists with the same name as the alias");
        }
    }

    public static void validateAliasName(String alias) {
        if (!Strings.hasText(alias)) {
            throw new IllegalArgumentException("alias name is required");
        }
        IndexName.validate(alias, InvalidAliasNameException::new);
    }
}

