/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;

public class IndexNameExpressionResolver {
    private IndexNameExpressionResolver() {
    }

    public static String[] concreteIndexNames(ClusterState state, IndicesRequest request) {
        return IndexNameExpressionResolver.concreteIndexNames(state.metadata(), request.indicesOptions(), request.indices());
    }

    public static Index[] concreteIndices(ClusterState state, IndicesRequest request) {
        return IndexNameExpressionResolver.concreteIndices(state.metadata(), request.indicesOptions(), request.indices());
    }

    public static String[] concreteIndexNames(Metadata metadata, IndicesOptions options, String ... indexExpressions) {
        Index[] indexes = IndexNameExpressionResolver.concreteIndices(metadata, options, indexExpressions);
        String[] names = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            names[i] = indexes[i].getName();
        }
        return names;
    }

    public static Index[] concreteIndices(Metadata metadata, IndicesOptions options, String ... indexExpressions) {
        boolean failClosed;
        if (indexExpressions == null || indexExpressions.length == 0) {
            indexExpressions = new String[]{"_all"};
        }
        boolean bl = failClosed = options.forbidClosedIndices() && !options.ignoreUnavailable();
        boolean failNoIndices = indexExpressions.length == 1 ? !options.allowNoIndices() : !options.ignoreUnavailable();
        List<String> expressions = IndexNameExpressionResolver.resolve(metadata, options, Arrays.asList(indexExpressions));
        if (expressions.isEmpty()) {
            if (!options.allowNoIndices()) {
                IndexNotFoundException infe = new IndexNotFoundException((String)null);
                infe.setResources("index_expression", indexExpressions);
                throw infe;
            }
            return Index.EMPTY_ARRAY;
        }
        HashSet<Index> concreteIndices = new HashSet<Index>(expressions.size());
        for (String expression : expressions) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)metadata.getAliasAndIndexLookup().get(expression);
            if (aliasOrIndex == null) {
                if (!failNoIndices) continue;
                IndexNotFoundException infe = new IndexNotFoundException(expression);
                infe.setResources("index_expression", expression);
                throw infe;
            }
            for (IndexMetadata index : aliasOrIndex.getIndices()) {
                if (index.getState() == IndexMetadata.State.CLOSE) {
                    if (failClosed) {
                        throw new IndexClosedException(index.getIndex());
                    }
                    if (options.forbidClosedIndices()) continue;
                    concreteIndices.add(index.getIndex());
                    continue;
                }
                if (index.getState() == IndexMetadata.State.OPEN) {
                    concreteIndices.add(index.getIndex());
                    continue;
                }
                throw new IllegalStateException("index state [" + String.valueOf((Object)index.getState()) + "] not supported");
            }
        }
        if (!options.allowNoIndices() && concreteIndices.isEmpty()) {
            IndexNotFoundException infe = new IndexNotFoundException((String)null);
            infe.setResources("index_expression", indexExpressions);
            throw infe;
        }
        return concreteIndices.toArray(new Index[concreteIndices.size()]);
    }

    public static Index concreteSingleIndex(ClusterState state, IndicesRequest request) {
        String indexExpression = request.indices().length == 0 ? null : request.indices()[0];
        String[] indexExpressions = new String[]{indexExpression};
        Index[] indices = IndexNameExpressionResolver.concreteIndices(state.metadata(), request.indicesOptions(), indexExpressions);
        if (indices.length != 1) {
            throw new IllegalArgumentException("unable to return a single index as the index and options provided got resolved to multiple indices");
        }
        return indices[0];
    }

    public static boolean isAllIndices(List<String> aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.isEmpty() || IndexNameExpressionResolver.isExplicitAllPattern(aliasesOrIndices);
    }

    static boolean isExplicitAllPattern(List<String> aliasesOrIndices) {
        return aliasesOrIndices != null && aliasesOrIndices.size() == 1 && "_all".equals(aliasesOrIndices.get(0));
    }

    private static List<String> resolve(Metadata metadata, IndicesOptions options, List<String> expressions) {
        if (!options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
            return expressions;
        }
        if (IndexNameExpressionResolver.isEmptyOrTrivialWildcard(expressions)) {
            return IndexNameExpressionResolver.resolveEmptyOrTrivialWildcard(options, metadata);
        }
        Set<String> result = IndexNameExpressionResolver.innerResolve(metadata, options, expressions);
        if (result == null) {
            return expressions;
        }
        if (result.isEmpty() && !options.allowNoIndices()) {
            IndexNotFoundException infe = new IndexNotFoundException((String)null);
            infe.setResources("index_or_alias", expressions.toArray(new String[0]));
            throw infe;
        }
        return new ArrayList<String>(result);
    }

    private static Set<String> innerResolve(Metadata metadata, IndicesOptions options, List<String> expressions) {
        HashSet<String> result = null;
        boolean wildcardSeen = false;
        for (int i = 0; i < expressions.size(); ++i) {
            boolean add;
            String expression = expressions.get(i);
            if (Strings.isNullOrEmpty(expression)) {
                throw IndexNameExpressionResolver.indexNotFoundException(expression);
            }
            if (IndexNameExpressionResolver.aliasOrIndexExists(metadata, options, expression)) {
                if (result == null) continue;
                result.add(expression);
                continue;
            }
            if (expression.charAt(0) == '-' && wildcardSeen) {
                add = false;
                expression = expression.substring(1);
            } else {
                add = true;
            }
            if (result == null) {
                result = new HashSet<String>(expressions.subList(0, i));
            }
            if (!Regex.isSimpleMatchPattern(expression)) {
                AliasOrIndex aliasOrIndex;
                if (!options.ignoreUnavailable() && (aliasOrIndex = (AliasOrIndex)metadata.getAliasAndIndexLookup().get(expression)) == null) {
                    throw IndexNameExpressionResolver.indexNotFoundException(expression);
                }
                if (add) {
                    result.add(expression);
                    continue;
                }
                result.remove(expression);
                continue;
            }
            IndexMetadata.State excludeState = IndexNameExpressionResolver.excludeState(options);
            Map<String, AliasOrIndex> matches = IndexNameExpressionResolver.matches(metadata, options, expression);
            Set<String> expand = IndexNameExpressionResolver.expand(excludeState, matches);
            if (add) {
                result.addAll(expand);
            } else {
                result.removeAll(expand);
            }
            if (!options.allowNoIndices() && matches.isEmpty()) {
                throw IndexNameExpressionResolver.indexNotFoundException(expression);
            }
            if (!Regex.isSimpleMatchPattern(expression)) continue;
            wildcardSeen = true;
        }
        return result;
    }

    private static boolean aliasOrIndexExists(Metadata metadata, IndicesOptions options, String expression) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metadata.getAliasAndIndexLookup().get(expression);
        return aliasOrIndex != null;
    }

    private static IndexNotFoundException indexNotFoundException(String expression) {
        IndexNotFoundException infe = new IndexNotFoundException(expression);
        infe.setResources("index_or_alias", expression);
        return infe;
    }

    private static IndexMetadata.State excludeState(IndicesOptions options) {
        IndexMetadata.State excludeState;
        if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
            excludeState = null;
        } else if (options.expandWildcardsOpen() && !options.expandWildcardsClosed()) {
            excludeState = IndexMetadata.State.CLOSE;
        } else if (options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
            excludeState = IndexMetadata.State.OPEN;
        } else {
            assert (false) : "this shouldn't get called if wildcards expand to none";
            excludeState = null;
        }
        return excludeState;
    }

    private static Map<String, AliasOrIndex> matches(Metadata metadata, IndicesOptions options, String expression) {
        if (Regex.isMatchAllPattern(expression)) {
            return metadata.getAliasAndIndexLookup();
        }
        if (expression.indexOf("*") == expression.length() - 1) {
            return IndexNameExpressionResolver.suffixWildcard(metadata, options, expression);
        }
        return IndexNameExpressionResolver.otherWildcard(metadata, options, expression);
    }

    private static Map<String, AliasOrIndex> suffixWildcard(Metadata metadata, IndicesOptions options, String expression) {
        assert (expression.length() >= 2) : "expression [" + expression + "] should have at least a length of 2";
        String fromPrefix = expression.substring(0, expression.length() - 1);
        char[] toPrefixCharArr = fromPrefix.toCharArray();
        int n = toPrefixCharArr.length - 1;
        toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
        String toPrefix = new String(toPrefixCharArr);
        SortedMap<String, AliasOrIndex> subMap = metadata.getAliasAndIndexLookup().subMap(fromPrefix, toPrefix);
        return subMap;
    }

    private static Map<String, AliasOrIndex> otherWildcard(Metadata metadata, IndicesOptions options, String expression) {
        String pattern = expression;
        return metadata.getAliasAndIndexLookup().entrySet().stream().filter(e -> !((AliasOrIndex)e.getValue()).isAlias()).filter(e -> Regex.simpleMatch(pattern, (String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Set<String> expand(IndexMetadata.State excludeState, Map<String, AliasOrIndex> matches) {
        HashSet<String> expand = new HashSet<String>();
        for (Map.Entry<String, AliasOrIndex> entry : matches.entrySet()) {
            AliasOrIndex aliasOrIndex = entry.getValue();
            for (IndexMetadata meta : aliasOrIndex.getIndices()) {
                if (excludeState != null && meta.getState() == excludeState) continue;
                expand.add(meta.getIndex().getName());
            }
        }
        return expand;
    }

    private static boolean isEmptyOrTrivialWildcard(List<String> expressions) {
        return expressions.isEmpty() || expressions.size() == 1 && ("_all".equals(expressions.get(0)) || Regex.isMatchAllPattern(expressions.get(0)));
    }

    private static List<String> resolveEmptyOrTrivialWildcard(IndicesOptions options, Metadata metadata) {
        if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
            return Arrays.asList(metadata.getConcreteAllIndices());
        }
        if (options.expandWildcardsOpen()) {
            return Arrays.asList(metadata.getConcreteAllOpenIndices());
        }
        if (options.expandWildcardsClosed()) {
            return Arrays.asList(metadata.getConcreteAllClosedIndices());
        }
        return Collections.emptyList();
    }
}

