/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Comparator;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public class NodeAllocationResult
implements Writeable,
Comparable<NodeAllocationResult> {
    private static final Comparator<NodeAllocationResult> NODE_RESULT_COMPARATOR = Comparator.comparing(NodeAllocationResult::getNodeDecision).thenComparingInt(NodeAllocationResult::getWeightRanking).thenComparing(r -> r.getNode().getId());
    private final DiscoveryNode node;
    @Nullable
    private final ShardStoreInfo shardStoreInfo;
    private final AllocationDecision nodeDecision;
    @Nullable
    private final Decision canAllocateDecision;
    private final int weightRanking;

    public NodeAllocationResult(DiscoveryNode node, ShardStoreInfo shardStoreInfo, @Nullable Decision decision) {
        this.node = node;
        this.shardStoreInfo = shardStoreInfo;
        this.canAllocateDecision = decision;
        this.nodeDecision = decision != null ? AllocationDecision.fromDecisionType(this.canAllocateDecision.type()) : AllocationDecision.NO;
        this.weightRanking = 0;
    }

    public NodeAllocationResult(DiscoveryNode node, AllocationDecision nodeDecision, Decision canAllocate, int weightRanking) {
        this.node = node;
        this.shardStoreInfo = null;
        this.canAllocateDecision = canAllocate;
        this.nodeDecision = nodeDecision;
        this.weightRanking = weightRanking;
    }

    public NodeAllocationResult(DiscoveryNode node, Decision decision, int weightRanking) {
        this.node = node;
        this.shardStoreInfo = null;
        this.canAllocateDecision = decision;
        this.nodeDecision = AllocationDecision.fromDecisionType(decision.type());
        this.weightRanking = weightRanking;
    }

    public NodeAllocationResult(StreamInput in) throws IOException {
        this.node = new DiscoveryNode(in);
        this.shardStoreInfo = in.readOptionalWriteable(ShardStoreInfo::new);
        this.canAllocateDecision = in.readOptionalWriteable(Decision::readFrom);
        this.nodeDecision = AllocationDecision.readFrom(in);
        this.weightRanking = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
        out.writeOptionalWriteable(this.shardStoreInfo);
        out.writeOptionalWriteable(this.canAllocateDecision);
        this.nodeDecision.writeTo(out);
        out.writeVInt(this.weightRanking);
    }

    public DiscoveryNode getNode() {
        return this.node;
    }

    @Nullable
    public ShardStoreInfo getShardStoreInfo() {
        return this.shardStoreInfo;
    }

    @Nullable
    public Decision getCanAllocateDecision() {
        return this.canAllocateDecision;
    }

    public boolean isWeightRanked() {
        return this.weightRanking > 0;
    }

    public int getWeightRanking() {
        return this.weightRanking;
    }

    public AllocationDecision getNodeDecision() {
        return this.nodeDecision;
    }

    @Override
    public int compareTo(NodeAllocationResult other) {
        return NODE_RESULT_COMPARATOR.compare(this, other);
    }

    public static final class ShardStoreInfo
    implements Writeable {
        private final boolean inSync;
        @Nullable
        private final String allocationId;
        private final long matchingBytes;
        @Nullable
        private final Exception storeException;

        public ShardStoreInfo(String allocationId, boolean inSync, Exception storeException) {
            this.inSync = inSync;
            this.allocationId = allocationId;
            this.matchingBytes = -1L;
            this.storeException = storeException;
        }

        public ShardStoreInfo(long matchingBytes) {
            this.inSync = false;
            this.allocationId = null;
            this.matchingBytes = matchingBytes;
            this.storeException = null;
        }

        public ShardStoreInfo(StreamInput in) throws IOException {
            this.inSync = in.readBoolean();
            this.allocationId = in.readOptionalString();
            this.matchingBytes = in.readLong();
            this.storeException = in.readException();
        }

        public boolean isInSync() {
            return this.inSync;
        }

        @Nullable
        public String getAllocationId() {
            return this.allocationId;
        }

        public boolean hasMatchingSyncId() {
            return this.matchingBytes == Long.MAX_VALUE;
        }

        public long getMatchingBytes() {
            return this.matchingBytes;
        }

        @Nullable
        public Exception getStoreException() {
            return this.storeException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.inSync);
            out.writeOptionalString(this.allocationId);
            out.writeLong(this.matchingBytes);
            out.writeException(this.storeException);
        }
    }
}

