/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.geo.MortonEncoder;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final int PRECISION = 12;
    public static final short BITS = 31;
    private static final short MORTON_OFFSET = 2;

    private GeoHashUtils() {
    }

    public static long encodeLatLon(double lat, double lon) {
        return MortonEncoder.encode(lat, lon) >>> 2;
    }

    public static long fromMorton(long morton, int level) {
        long mFlipped = BitUtil.flipFlop((long)morton);
        return (mFlipped >>>= (12 - level) * 5 + 2) << 4 | (long)level;
    }

    public static final String stringEncode(double lon, double lat) {
        int level = 12;
        long ghLong = GeoHashUtils.fromMorton(GeoHashUtils.encodeLatLon(lat, lon), level);
        int level1 = (int)ghLong & 0xF;
        ghLong >>>= 4;
        char[] chars = new char[level1];
        do {
            chars[--level1] = BASE_32[(int)(ghLong & 0x1FL)];
            ghLong >>>= 5;
        } while (level1 > 0);
        return new String(chars);
    }
}

