/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.geo.Polygon;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiPolygonBuilder
extends ShapeBuilder {
    public static final GeoShapeType TYPE = GeoShapeType.MULTIPOLYGON;
    private final List<PolygonBuilder> polygons = new ArrayList<PolygonBuilder>();
    private final ShapeBuilder.Orientation orientation;

    public MultiPolygonBuilder() {
        this(ShapeBuilder.Orientation.RIGHT);
    }

    public MultiPolygonBuilder(ShapeBuilder.Orientation orientation) {
        this.orientation = orientation;
    }

    public MultiPolygonBuilder polygon(PolygonBuilder polygon) {
        PolygonBuilder pb = new PolygonBuilder(new CoordinatesBuilder().coordinates(polygon.shell().coordinates(false)), this.orientation);
        for (LineStringBuilder hole : polygon.holes()) {
            pb.hole(hole);
        }
        this.polygons.add(pb);
        return this;
    }

    public Shape buildS4J() {
        ArrayList<JtsGeometry> shapes = new ArrayList<JtsGeometry>(this.polygons.size());
        if (this.wrapdateline) {
            for (PolygonBuilder polygon : this.polygons) {
                for (Coordinate[][] part : polygon.coordinates()) {
                    shapes.add(this.jtsGeometry((Geometry)PolygonBuilder.polygonS4J(GEO_FACTORY, part)));
                }
            }
        } else {
            for (PolygonBuilder polygon : this.polygons) {
                shapes.add(this.jtsGeometry((Geometry)polygon.toPolygonS4J(GEO_FACTORY)));
            }
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    @Override
    public Object buildLucene() {
        ArrayList<Polygon> shapes = new ArrayList<Polygon>(this.polygons.size());
        if (this.wrapdateline) {
            for (PolygonBuilder polygon : this.polygons) {
                Object poly = polygon.buildLucene();
                if (poly instanceof Polygon[]) {
                    shapes.addAll(Arrays.asList((Polygon[])poly));
                    continue;
                }
                shapes.add((Polygon)poly);
            }
        } else {
            for (int i = 0; i < this.polygons.size(); ++i) {
                PolygonBuilder pb = this.polygons.get(i);
                Object poly = pb.buildLucene();
                if (poly instanceof Polygon[]) {
                    shapes.addAll(Arrays.asList((Polygon[])poly));
                    continue;
                }
                shapes.add((Polygon)poly);
            }
        }
        return shapes.stream().toArray(Polygon[]::new);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.polygons, this.orientation});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPolygonBuilder other = (MultiPolygonBuilder)obj;
        return Objects.equals(this.polygons, other.polygons) && Objects.equals((Object)this.orientation, (Object)other.orientation);
    }
}

