/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import io.crate.common.SuppressForbidden;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.jetbrains.annotations.Nullable;

public class FutureUtils {
    @SuppressForbidden(reason="Future#cancel()")
    public static boolean cancel(@Nullable Future<?> toCancel) {
        if (toCancel != null) {
            return toCancel.cancel(false);
        }
        return false;
    }

    public static <T> T get(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            throw FutureUtils.rethrowExecutionException(e);
        }
    }

    public static <T> T get(Future<T> future, TimeValue timeValue) {
        return FutureUtils.get(future, timeValue.millis(), TimeUnit.MILLISECONDS);
    }

    public static <T> T get(Future<T> future, long timeout, TimeUnit unit) {
        try {
            return future.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ElasticsearchTimeoutException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            throw FutureUtils.rethrowExecutionException(e);
        }
    }

    public static RuntimeException rethrowExecutionException(ExecutionException e) {
        return Exceptions.toRuntimeException((Throwable)SQLExceptions.unwrap(e));
    }
}

