/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenFilter
extends PreConfiguredAnalysisComponent<TokenFilterFactory> {
    private final boolean useFilterForMultitermQueries;
    private final BiFunction<TokenStream, Version, TokenStream> create;

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, UnaryOperator<TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter singletonWithVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, (Version)version));
    }

    public static PreConfiguredTokenFilter luceneVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, org.apache.lucene.util.Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.LUCENE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, version.luceneVersion));
    }

    public static PreConfiguredTokenFilter elasticsearchVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, create);
    }

    private PreConfiguredTokenFilter(String name, boolean useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy cache, BiFunction<TokenStream, Version, TokenStream> create) {
        super(name, cache);
        this.useFilterForMultitermQueries = useFilterForMultitermQueries;
        this.create = create;
    }

    public boolean shouldUseFilterForMultitermQueries() {
        return this.useFilterForMultitermQueries;
    }

    @Override
    protected TokenFilterFactory create(final Version version) {
        if (this.useFilterForMultitermQueries) {
            return new MultiTermAwareTokenFilterFactory(){
                final /* synthetic */ PreConfiguredTokenFilter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String name() {
                    return this.this$0.getName();
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return this.this$0.create.apply(tokenStream, version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return this;
                }
            };
        }
        return new TokenFilterFactory(){
            final /* synthetic */ PreConfiguredTokenFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String name() {
                return this.this$0.getName();
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return this.this$0.create.apply(tokenStream, version);
            }
        };
    }

    private static interface MultiTermAwareTokenFilterFactory
    extends TokenFilterFactory,
    MultiTermAwareComponent {
    }
}

