/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene912.Lucene912Codec;
import org.elasticsearch.index.codec.CrateCodec;

public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService() {
        HashMap<String, CrateCodec> codecs = new HashMap<String, CrateCodec>();
        codecs.put(DEFAULT_CODEC, new CrateCodec(Lucene912Codec.Mode.BEST_SPEED));
        codecs.put(BEST_COMPRESSION_CODEC, new CrateCodec(Lucene912Codec.Mode.BEST_COMPRESSION));
        codecs.put(LUCENE_DEFAULT_CODEC, (CrateCodec)Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, (CrateCodec)Codec.forName((String)codec));
        }
        this.codecs = Map.copyOf(codecs);
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

