/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public abstract class SlicedInputStream
extends InputStream {
    private int slice = 0;
    private InputStream currentStream;
    private final int numSlices;
    private boolean initialized = false;

    protected SlicedInputStream(int numSlices) {
        this.numSlices = numSlices;
    }

    private InputStream nextStream() throws IOException {
        assert (!this.initialized || this.currentStream != null);
        this.initialized = true;
        IOUtils.close((Closeable[])new Closeable[]{this.currentStream});
        this.currentStream = this.slice < this.numSlices ? this.openSlice(this.slice++) : null;
        return this.currentStream;
    }

    protected abstract InputStream openSlice(int var1) throws IOException;

    private InputStream currentStream() throws IOException {
        if (this.currentStream == null) {
            return this.initialized ? null : this.nextStream();
        }
        return this.currentStream;
    }

    @Override
    public final int read() throws IOException {
        InputStream stream = this.currentStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read();
        if (read == -1) {
            this.nextStream();
            return this.read();
        }
        return read;
    }

    @Override
    public final int read(byte[] buffer, int offset, int length) throws IOException {
        InputStream stream = this.currentStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read(buffer, offset, length);
        if (read <= 0) {
            this.nextStream();
            return this.read(buffer, offset, length);
        }
        return read;
    }

    @Override
    public final void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.currentStream});
        this.initialized = true;
        this.currentStream = null;
    }

    @Override
    public final int available() throws IOException {
        InputStream stream = this.currentStream();
        return stream == null ? 0 : stream.available();
    }
}

