/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.engine.SubscriberEngine;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.seqno.RetentionLeaseBackgroundSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.indices.store.IndicesStore;

public class IndicesModule
extends AbstractModule {
    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of();
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Collections.emptyList();
    }

    protected void configure() {
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(SyncedFlushService.class).asEagerSingleton();
        this.bind(TransportResyncReplicationAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseBackgroundSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncer.class).asEagerSingleton();
    }

    public Collection<Function<IndexSettings, Optional<EngineFactory>>> getEngineFactories() {
        return List.of(indexSettings -> {
            if (indexSettings.getSettings().get(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey()) != null) {
                return Optional.of(SubscriberEngine::new);
            }
            return Optional.empty();
        });
    }
}

