/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class Plugin
implements Closeable {
    public Collection<Module> createGuiceModules() {
        return Collections.emptyList();
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        return Collections.emptyList();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.emptyList();
    }

    public Settings additionalSettings() {
        return Settings.EMPTY;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.emptyList();
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Collections.emptyList();
    }

    public void onIndexModule(IndexModule indexModule) {
    }

    public List<Setting<?>> getSettings() {
        return Collections.emptyList();
    }

    public List<SettingUpgrader<?>> getSettingUpgraders() {
        return Collections.emptyList();
    }

    public UnaryOperator<Map<String, Metadata.Custom>> getCustomMetadataUpgrader() {
        return UnaryOperator.identity();
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return UnaryOperator.identity();
    }

    public BiFunction<IndexMetadata, IndexTemplateMetadata, IndexMetadata> getIndexMetadataUpgrader() {
        return (indexMetadata, indexTemplateMetadata) -> indexMetadata;
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return Collections.emptyList();
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return Set.of();
    }

    @Override
    public void close() throws IOException {
    }
}

