/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;

public class PluginInfo {
    public static final String ES_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    private final String name;
    private final String description;
    private final String classname;

    public PluginInfo(String name, String description, String classname, List<String> extendedPlugins) {
        this.name = name;
        this.description = description;
        this.classname = classname;
    }

    public static PluginInfo readFromProperties(Path path) throws IOException {
        Path descriptor = path.resolve(ES_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing in [" + String.valueOf(descriptor) + "]");
        }
        String description = propsMap.remove("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for plugin [" + name + "]");
        }
        String classname = propsMap.remove("classname");
        if (classname == null) {
            throw new IllegalArgumentException("property [classname] is missing for plugin [" + name + "]");
        }
        String extendedString = propsMap.remove("extended.plugins");
        List<Object> extendedPlugins = extendedString == null ? Collections.emptyList() : Arrays.asList(Strings.delimitedListToStringArray(extendedString, ","));
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties in plugin descriptor: " + String.valueOf(propsMap.keySet()));
        }
        return new PluginInfo(name, description, classname, extendedPlugins);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        return this.classname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder information = new StringBuilder().append(prefix).append("- Plugin information:\n").append(prefix).append("Name: ").append(this.name).append("\n").append(prefix).append("Description: ").append(this.description).append("\n").append(prefix).append(" * Classname: ").append(this.classname);
        return information.toString();
    }
}

