/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileScorer;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final QueryProfileBreakdown profile;

    public ProfileWeight(Query query, Weight subQueryWeight, QueryProfileBreakdown profile) throws IOException {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier supplier = this.scorerSupplier(context);
        if (supplier == null) {
            return null;
        }
        return supplier.get(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final Timer timer = this.profile.getTimer(QueryTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.subQueryWeight.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        final ProfileWeight weight = this;
        return new ScorerSupplier(this){
            final /* synthetic */ ProfileWeight this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    ProfileScorer profileScorer = new ProfileScorer(weight, subQueryScorerSupplier.get(loadCost), this.this$0.profile);
                    return profileScorer;
                }
                finally {
                    timer.stop();
                }
            }

            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        return super.bulkScorer(context);
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.subQueryWeight.isCacheable(ctx);
    }
}

