/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;

public class RestoreInfo
implements Writeable {
    private final String name;
    private final List<String> indices;
    private final int totalShards;
    private final int successfulShards;

    public RestoreInfo(String name, List<String> indices, int totalShards, int successfulShards) {
        this.name = name;
        this.indices = indices;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
    }

    public RestoreInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.indices = Collections.unmodifiableList(in.readStringList());
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
    }

    public String name() {
        return this.name;
    }

    public List<String> indices() {
        return this.indices;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.indices);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreInfo that = (RestoreInfo)o;
        return this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.name, that.name) && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.indices, this.totalShards, this.successfulShards);
    }
}

