/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.crate.auth.Authentication;
import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Credentials;
import io.crate.auth.Protocol;
import io.crate.protocols.SSL;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Role;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import javax.security.sasl.AuthenticationException;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.transport.netty4.Netty4Transport;

public class HostBasedAuthHandler
extends ChannelInboundHandlerAdapter {
    private final Authentication authentication;
    private Exception authError;

    public HostBasedAuthHandler(Authentication authentication) {
        this.authentication = authentication;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Credentials credentials;
        ConnectionProperties connectionProperties;
        if (this.authError != null) {
            HostBasedAuthHandler.closeAndThrowException(ctx, msg, this.authError);
        }
        Channel channel = ctx.channel();
        InetAddress remoteAddress = Netty4HttpServerTransport.getRemoteAddress(channel);
        String userName = Role.CRATE_USER.name();
        AuthenticationMethod authMethod = this.authentication.resolveAuthenticationType(userName, connectionProperties = new ConnectionProperties(credentials = new Credentials(userName, null), remoteAddress, Protocol.TRANSPORT, SSL.getSession(channel)));
        if (authMethod == null) {
            this.authError = new AuthenticationException("No valid auth.host_based entry found for: " + String.valueOf(remoteAddress));
            HostBasedAuthHandler.closeAndThrowException(ctx, msg, this.authError);
        }
        try {
            authMethod.authenticate(credentials, connectionProperties);
            ctx.pipeline().remove((ChannelHandler)this);
            super.channelRead(ctx, msg);
        }
        catch (Exception e) {
            this.authError = e;
            HostBasedAuthHandler.closeAndThrowException(ctx, msg, this.authError);
        }
    }

    private static void closeAndThrowException(ChannelHandlerContext ctx, Object msg, Exception e) throws Exception {
        ReferenceCountUtil.release((Object)msg);
        CloseableChannel tcpChannel = (CloseableChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        CloseableChannel.closeChannel(tcpChannel, true);
        throw e;
    }
}

